/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.bridge.builtin.time.impl;

import java.lang.invoke.MethodHandles;
import java.time.DateTimeException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.util.Locale;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchOffsetDateTimeBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchTemporalAccessorStringBridge;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.impl.TimeHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchZonedDateTimeBridge
extends ElasticsearchTemporalAccessorStringBridge<ZonedDateTime> {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().append(ElasticsearchOffsetDateTimeBridge.FORMATTER).appendLiteral('[').parseCaseSensitive().appendZoneRegionId().appendLiteral(']').toFormatter(Locale.ROOT).withResolverStyle(ResolverStyle.STRICT);
    public static final ElasticsearchZonedDateTimeBridge INSTANCE = new ElasticsearchZonedDateTimeBridge();

    private ElasticsearchZonedDateTimeBridge() {
        super(FORMATTER, ZonedDateTime.class);
    }

    @Override
    ZonedDateTime parse(DateTimeFormatter formatter, String stringValue) throws DateTimeException {
        return TimeHelper.parseZoneDateTime((String)stringValue, (DateTimeFormatter)formatter);
    }

    @Override
    protected IllegalArgumentException createInvalidIndexNullAsException(String indexNullAs, DateTimeException e) {
        return LOG.invalidNullMarkerForZonedDateTime(e);
    }
}

