/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.util.impl;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.lucene.document.DateTools;

public final class ElasticsearchDateHelper {
    private static final TimeZone ENCODING_TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 9, SignStyle.NORMAL).appendLiteral("-").appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral("-").appendValue(ChronoField.DAY_OF_MONTH, 2).optionalStart().appendLiteral("T").appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(":").appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(":").appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 3, 3, true).optionalEnd().optionalEnd().optionalStart().appendOffset("+HH:MM", "Z").optionalEnd().toFormatter();

    private ElasticsearchDateHelper() {
    }

    public static Date stringToDate(String value) {
        Calendar c = ElasticsearchDateHelper.stringToCalendar(value);
        return c.getTime();
    }

    public static String dateToString(Date date) {
        Calendar c = Calendar.getInstance(ENCODING_TIME_ZONE, Locale.ENGLISH);
        c.setTime(date);
        return ElasticsearchDateHelper.calendarToString(c);
    }

    public static String calendarToString(Calendar calendar) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(calendar.getTimeInMillis()), calendar.getTimeZone().toZoneId());
        return FORMATTER.format(zonedDateTime);
    }

    public static Calendar stringToCalendar(String value) {
        String val = value.trim();
        return FORMATTER.parse((CharSequence)val, ElasticsearchDateHelper::fromTemporal);
    }

    public static Calendar round(Calendar calendar, DateTools.Resolution resolution) {
        Calendar calInstance = (Calendar)calendar.clone();
        calInstance.setTime(DateTools.round((Date)calInstance.getTime(), (DateTools.Resolution)resolution));
        return calInstance;
    }

    private static Calendar fromTemporal(TemporalAccessor temporal) {
        ZoneId zoneId;
        LocalDate date = LocalDate.from(temporal);
        LocalTime time = temporal.query(TemporalQueries.localTime());
        if (time == null) {
            time = LocalTime.of(0, 0, 0);
        }
        if ((zoneId = temporal.query(TemporalQueries.zone())) == null) {
            zoneId = TimeZone.getDefault().toZoneId();
        }
        return GregorianCalendar.from(ZonedDateTime.of(date, time, zoneId));
    }
}

