/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.impl;

import org.hibernate.search.analyzer.spi.AnalyzerStrategy;
import org.hibernate.search.elasticsearch.impl.ElasticsearchService;
import org.hibernate.search.elasticsearch.indexes.ElasticsearchIndexFamily;
import org.hibernate.search.engine.nulls.impl.MissingValueStrategy;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.IndexFamilyImplementor;

public class ElasticsearchIndexFamilyImpl
implements IndexFamilyImplementor,
ElasticsearchIndexFamily {
    private final ServiceManager serviceManager;
    private final ElasticsearchService elasticsearchService;

    public ElasticsearchIndexFamilyImpl(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
        this.elasticsearchService = (ElasticsearchService)serviceManager.requestService(ElasticsearchService.class);
    }

    public void close() {
        this.serviceManager.releaseService(ElasticsearchService.class);
    }

    public <T> T unwrap(Class<T> unwrappedClass) {
        if (unwrappedClass.isAssignableFrom(ElasticsearchIndexFamily.class)) {
            return (T)this;
        }
        throw new SearchException("Cannot unwrap a '" + this.getClass().getName() + "' into a '" + unwrappedClass.getName() + "'");
    }

    @Override
    public <T> T getClient(Class<T> clientClass) {
        return this.elasticsearchService.getClient(clientClass);
    }

    public AnalyzerStrategy createAnalyzerStrategy() {
        return this.elasticsearchService.getAnalyzerStrategyFactory().create();
    }

    public MissingValueStrategy getMissingValueStrategy() {
        return this.elasticsearchService.getMissingValueStrategy();
    }
}

