/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.cfg;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum IndexSchemaManagementStrategy {
    NONE("none"),
    VALIDATE("validate"),
    UPDATE("update"),
    CREATE("create"),
    DROP_AND_CREATE("drop-and-create"),
    DROP_AND_CREATE_AND_DROP("drop-and-create-and-drop");

    private static final Map<String, IndexSchemaManagementStrategy> VALUES_BY_EXTERNAL_NAME;
    private final String externalName;

    public static IndexSchemaManagementStrategy interpretPropertyValue(String propertyValue) {
        String normalizedName = propertyValue.trim().toLowerCase(Locale.ROOT);
        IndexSchemaManagementStrategy strategy = VALUES_BY_EXTERNAL_NAME.get(normalizedName);
        if (strategy == null) {
            throw new IllegalArgumentException("Unrecognized property value for an index schema management strategy: '" + propertyValue + "'. Please use one of " + VALUES_BY_EXTERNAL_NAME.keySet());
        }
        return strategy;
    }

    private IndexSchemaManagementStrategy(String propertyValue) {
        this.externalName = propertyValue;
    }

    public String getExternalName() {
        return this.externalName;
    }

    static {
        HashMap<String, IndexSchemaManagementStrategy> tmpMap = new HashMap<String, IndexSchemaManagementStrategy>();
        for (IndexSchemaManagementStrategy strategy : IndexSchemaManagementStrategy.values()) {
            tmpMap.put(strategy.externalName.toLowerCase(Locale.ROOT), strategy);
        }
        VALUES_BY_EXTERNAL_NAME = Collections.unmodifiableMap(tmpMap);
    }
}

