/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.dialect.impl.es50;

import com.google.gson.GsonBuilder;
import java.util.Properties;
import org.hibernate.search.elasticsearch.dialect.impl.es2.Elasticsearch2Dialect;
import org.hibernate.search.elasticsearch.gson.impl.GsonProvider;
import org.hibernate.search.elasticsearch.query.impl.Elasticsearch5QueryFactory;
import org.hibernate.search.elasticsearch.query.impl.ElasticsearchQueryFactory;
import org.hibernate.search.elasticsearch.schema.impl.Elasticsearch50SchemaTranslator;
import org.hibernate.search.elasticsearch.schema.impl.Elasticsearch50SchemaValidator;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaAccessor;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaTranslator;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaValidator;
import org.hibernate.search.elasticsearch.schema.impl.model.FieldDataType;
import org.hibernate.search.elasticsearch.schema.impl.model.IndexType;
import org.hibernate.search.elasticsearch.schema.impl.model.NormsType;
import org.hibernate.search.elasticsearch.util.impl.gson.ES5FieldDataTypeJsonAdapter;
import org.hibernate.search.elasticsearch.util.impl.gson.ES5IndexTypeJsonAdapter;
import org.hibernate.search.elasticsearch.util.impl.gson.ES5NormsTypeJsonAdapter;
import org.hibernate.search.elasticsearch.work.impl.factory.Elasticsearch5WorkFactory;
import org.hibernate.search.elasticsearch.work.impl.factory.ElasticsearchWorkFactory;

public class Elasticsearch50Dialect
extends Elasticsearch2Dialect {
    public Elasticsearch50Dialect(Properties properties) {
        super(properties);
    }

    @Override
    public GsonBuilder createGsonBuilderBase() {
        return new GsonBuilder().registerTypeAdapter(IndexType.class, (Object)new ES5IndexTypeJsonAdapter().nullSafe()).registerTypeAdapter(FieldDataType.class, (Object)new ES5FieldDataTypeJsonAdapter().nullSafe()).registerTypeAdapter(NormsType.class, (Object)new ES5NormsTypeJsonAdapter().nullSafe());
    }

    @Override
    public ElasticsearchWorkFactory createWorkFactory(GsonProvider gsonProvider) {
        return new Elasticsearch5WorkFactory(gsonProvider);
    }

    @Override
    public ElasticsearchSchemaTranslator createSchemaTranslator() {
        return new Elasticsearch50SchemaTranslator();
    }

    @Override
    public ElasticsearchSchemaValidator createSchemaValidator(ElasticsearchSchemaAccessor schemaAccessor) {
        return new Elasticsearch50SchemaValidator(schemaAccessor);
    }

    @Override
    public ElasticsearchQueryFactory createQueryFactory() {
        return new Elasticsearch5QueryFactory();
    }
}

