/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.nulls.codec.impl;

import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.spi.NullMarker;
import org.hibernate.search.elasticsearch.nulls.codec.impl.ElasticsearchAsTokenNullMarkerCodec;

public class ElasticsearchAsTokenStringNullMarkerCodec
extends ElasticsearchAsTokenNullMarkerCodec {
    private final BytesRef encodedToken;

    public ElasticsearchAsTokenStringNullMarkerCodec(NullMarker nullMarker) {
        super(nullMarker);
        this.encodedToken = new BytesRef((CharSequence)((String)nullMarker.nullEncoded()));
    }

    public void encodeNullValue(String name, Document document, LuceneOptions luceneOptions) {
        luceneOptions.addFieldToDocument(name, (String)this.nullMarker.nullEncoded(), document);
    }

    public Query createNullMatchingQuery(String fieldName) {
        return new TermQuery(new Term(fieldName, this.encodedToken));
    }

    public boolean representsNullValue(IndexableField field) {
        String stringValue = field.stringValue();
        return this.nullMarker.nullEncoded().equals(stringValue);
    }
}

