/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.bridge.builtin.time.impl;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.util.Locale;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchLocalDateBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchLocalTimeBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchTemporalAccessorStringBridge;

public class ElasticsearchInstantBridge
extends ElasticsearchTemporalAccessorStringBridge<Instant> {
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().append(ElasticsearchLocalDateBridge.FORMATTER).appendLiteral('T').optionalStart().append(ElasticsearchLocalTimeBridge.FORMATTER).optionalStart().appendOffsetId().toFormatter(Locale.ROOT).withResolverStyle(ResolverStyle.STRICT);
    public static final ElasticsearchInstantBridge INSTANCE = new ElasticsearchInstantBridge();

    private ElasticsearchInstantBridge() {
        super(FORMATTER, Instant.class);
    }

    @Override
    String format(DateTimeFormatter formatter, Instant object) {
        return formatter.format(object == null ? null : object.atOffset(ZoneOffset.UTC));
    }

    @Override
    Instant parse(DateTimeFormatter formatter, String stringValue) throws DateTimeParseException {
        return Instant.from(formatter.parse(stringValue));
    }
}

