/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.bridge.builtin.time.impl;

import java.time.MonthDay;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchTemporalAccessorStringBridge;

public class ElasticsearchMonthDayBridge
extends ElasticsearchTemporalAccessorStringBridge<MonthDay> {
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendLiteral("--").appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter(Locale.ROOT).withResolverStyle(ResolverStyle.STRICT);
    public static final ElasticsearchMonthDayBridge INSTANCE = new ElasticsearchMonthDayBridge();

    private ElasticsearchMonthDayBridge() {
        super(FORMATTER, MonthDay.class);
    }

    @Override
    MonthDay parse(DateTimeFormatter formatter, String stringValue) throws DateTimeParseException {
        return MonthDay.parse(stringValue, formatter);
    }
}

