/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.schema.impl;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.lucene.document.Field;
import org.hibernate.search.analyzer.impl.AnalyzerReference;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.elasticsearch.impl.GsonService;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.schema.impl.ElasticSearchIndexNullAsHelper;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchMappingBuilder;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaTranslator;
import org.hibernate.search.elasticsearch.schema.impl.ExecutionOptions;
import org.hibernate.search.elasticsearch.schema.impl.model.DataType;
import org.hibernate.search.elasticsearch.schema.impl.model.DynamicType;
import org.hibernate.search.elasticsearch.schema.impl.model.IndexType;
import org.hibernate.search.elasticsearch.schema.impl.model.PropertyMapping;
import org.hibernate.search.elasticsearch.schema.impl.model.TypeMapping;
import org.hibernate.search.elasticsearch.util.impl.FieldHelper;
import org.hibernate.search.engine.BoostStrategy;
import org.hibernate.search.engine.impl.DefaultBoostStrategy;
import org.hibernate.search.engine.metadata.impl.BridgeDefinedField;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.FacetMetadata;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.Startable;
import org.hibernate.search.engine.service.spi.Stoppable;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spatial.impl.SpatialHelper;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DefaultElasticsearchSchemaTranslator
implements ElasticsearchSchemaTranslator,
Startable,
Stoppable {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private ServiceManager serviceManager;
    private GsonService gsonService;

    public void start(Properties properties, BuildContext context) {
        this.serviceManager = context.getServiceManager();
        this.gsonService = (GsonService)this.serviceManager.requestService(GsonService.class);
    }

    public void stop() {
        this.gsonService = null;
        this.serviceManager.releaseService(GsonService.class);
        this.serviceManager = null;
    }

    @Override
    public TypeMapping translate(EntityIndexBinding descriptor, ExecutionOptions executionOptions) {
        TypeMapping root = new TypeMapping();
        root.setDynamic(DynamicType.STRICT);
        ElasticsearchMappingBuilder builder = new ElasticsearchMappingBuilder(descriptor, root);
        if (executionOptions.isMultitenancyEnabled()) {
            PropertyMapping tenantId = new PropertyMapping();
            tenantId.setType(DataType.STRING);
            tenantId.setIndex(IndexType.NOT_ANALYZED);
            builder.setPropertyAbsolute("__HSearch_TenantId", tenantId);
        }
        this.addMappings(builder);
        return root;
    }

    private void addMappings(ElasticsearchMappingBuilder mappingBuilder) {
        TypeMetadata typeMetadata = mappingBuilder.getMetadata();
        for (DocumentFieldMetadata fieldMetadata : typeMetadata.getNonEmbeddedDocumentFieldMetadata()) {
            try {
                this.addPropertyMapping(mappingBuilder, fieldMetadata);
            }
            catch (IncompleteDataException e) {
                LOG.debug("Not adding a mapping for field " + fieldMetadata.getAbsoluteName() + " because of incomplete data", (Throwable)((Object)e));
            }
        }
        for (BridgeDefinedField bridgeDefinedField : this.getNonEmbeddedBridgeDefinedFields(typeMetadata)) {
            try {
                this.addPropertyMapping(mappingBuilder, bridgeDefinedField);
            }
            catch (IncompleteDataException e) {
                LOG.debug("Not adding a mapping for field " + bridgeDefinedField.getAbsoluteName() + " because of incomplete data", (Throwable)((Object)e));
            }
        }
        for (EmbeddedTypeMetadata embeddedTypeMetadata : typeMetadata.getEmbeddedTypeMetadata()) {
            ElasticsearchMappingBuilder embeddedContext = mappingBuilder.createEmbedded(embeddedTypeMetadata);
            this.addMappings(embeddedContext);
        }
    }

    private void addPropertyMapping(ElasticsearchMappingBuilder mappingBuilder, DocumentFieldMetadata fieldMetadata) {
        if (fieldMetadata.getAbsoluteName().isEmpty() || fieldMetadata.getAbsoluteName().endsWith(".") || fieldMetadata.isSpatial()) {
            return;
        }
        String propertyPath = fieldMetadata.getAbsoluteName();
        PropertyMapping propertyMapping = new PropertyMapping();
        this.addTypeOptions(propertyMapping, fieldMetadata);
        propertyMapping.setStore(fieldMetadata.getStore() != Store.NO);
        this.addIndexOptions(propertyMapping, mappingBuilder, fieldMetadata.getSourceProperty(), fieldMetadata.getAbsoluteName(), fieldMetadata.getIndex(), fieldMetadata.getAnalyzerReference());
        propertyMapping.setBoost(Float.valueOf(mappingBuilder.getBoost(fieldMetadata.getBoost())));
        this.logDynamicBoostWarning(mappingBuilder, fieldMetadata.getSourceType().getDynamicBoost(), propertyPath);
        PropertyMetadata sourceProperty = fieldMetadata.getSourceProperty();
        if (sourceProperty != null) {
            this.logDynamicBoostWarning(mappingBuilder, sourceProperty.getDynamicBoostStrategy(), propertyPath);
        }
        this.addNullValue(propertyMapping, fieldMetadata);
        for (FacetMetadata facetMetadata : fieldMetadata.getFacetMetadata()) {
            try {
                this.addSubfieldMapping(propertyMapping, mappingBuilder, facetMetadata);
            }
            catch (IncompleteDataException e) {
                LOG.debug("Not adding a mapping for facet " + facetMetadata.getAbsoluteName() + " because of incomplete data", (Throwable)((Object)e));
            }
        }
        mappingBuilder.setPropertyAbsolute(propertyPath, propertyMapping);
    }

    private void logDynamicBoostWarning(ElasticsearchMappingBuilder mappingBuilder, BoostStrategy dynamicBoostStrategy, String fieldPath) {
        if (dynamicBoostStrategy != null && !DefaultBoostStrategy.INSTANCE.equals(dynamicBoostStrategy)) {
            LOG.unsupportedDynamicBoost(dynamicBoostStrategy.getClass(), mappingBuilder.getBeanClass(), fieldPath);
        }
    }

    private void addPropertyMapping(ElasticsearchMappingBuilder mappingBuilder, BridgeDefinedField bridgeDefinedField) {
        String propertyPath = bridgeDefinedField.getAbsoluteName();
        if (!SpatialHelper.isSpatialField((String)propertyPath)) {
            PropertyMapping propertyMapping = new PropertyMapping();
            this.addTypeOptions(propertyMapping, bridgeDefinedField);
            this.addIndexOptions(propertyMapping, mappingBuilder, bridgeDefinedField.getSourceField().getSourceProperty(), propertyPath, bridgeDefinedField.getIndex(), null);
            if (!mappingBuilder.hasPropertyAbsolute(propertyPath)) {
                mappingBuilder.setPropertyAbsolute(propertyPath, propertyMapping);
            }
        } else {
            if (SpatialHelper.isSpatialFieldLongitude((String)propertyPath)) {
                return;
            }
            if (SpatialHelper.isSpatialFieldLatitude((String)propertyPath)) {
                PropertyMapping propertyMapping = new PropertyMapping();
                propertyMapping.setType(DataType.GEO_POINT);
                mappingBuilder.setPropertyAbsolute(SpatialHelper.stripSpatialFieldSuffix((String)propertyPath), propertyMapping);
            } else {
                PropertyMapping propertyMapping = new PropertyMapping();
                propertyMapping.setType(DataType.STRING);
                propertyMapping.setIndex(IndexType.NOT_ANALYZED);
                mappingBuilder.setPropertyAbsolute(propertyPath, propertyMapping);
            }
        }
    }

    private void addSubfieldMapping(PropertyMapping propertyMapping, ElasticsearchMappingBuilder mappingBuilder, FacetMetadata facetMetadata) {
        String facetFieldName = facetMetadata.getPath().getRelativeName() + "__HSearch_Facet";
        PropertyMapping fieldMapping = new PropertyMapping();
        this.addTypeOptions(fieldMapping, facetMetadata);
        fieldMapping.setStore(false);
        fieldMapping.setIndex(IndexType.NOT_ANALYZED);
        propertyMapping.addField(facetFieldName, fieldMapping);
    }

    private void addIndexOptions(PropertyMapping propertyMapping, ElasticsearchMappingBuilder mappingBuilder, PropertyMetadata sourceProperty, String propertyPath, Field.Index index, AnalyzerReference analyzerReference) {
        IndexType elasticsearchIndex;
        switch (index) {
            case ANALYZED: 
            case ANALYZED_NO_NORMS: {
                elasticsearchIndex = this.canTypeBeAnalyzed(propertyMapping.getType()) ? IndexType.ANALYZED : IndexType.NOT_ANALYZED;
                break;
            }
            case NOT_ANALYZED: 
            case NOT_ANALYZED_NO_NORMS: {
                elasticsearchIndex = IndexType.NOT_ANALYZED;
                break;
            }
            case NO: {
                elasticsearchIndex = IndexType.NO;
                break;
            }
            default: {
                throw new AssertionFailure("Unexpected index type: " + index);
            }
        }
        propertyMapping.setIndex(elasticsearchIndex);
        if (IndexType.NO.equals((Object)elasticsearchIndex) && FieldHelper.isSortableField(mappingBuilder.getMetadata(), sourceProperty, propertyPath)) {
            propertyMapping.setDocValues(true);
        }
        if (IndexType.ANALYZED.equals((Object)elasticsearchIndex) && analyzerReference != null) {
            String analyzerName = mappingBuilder.getAnalyzerName(analyzerReference, propertyPath);
            propertyMapping.setAnalyzer(analyzerName);
        }
    }

    private boolean canTypeBeAnalyzed(DataType fieldType) {
        return DataType.STRING.equals((Object)fieldType);
    }

    private void addTypeOptions(PropertyMapping propertyMapping, DocumentFieldMetadata fieldMetadata) {
        this.addTypeOptions(fieldMetadata.getAbsoluteName(), propertyMapping, FieldHelper.getType(fieldMetadata));
    }

    private void addTypeOptions(PropertyMapping propertyMapping, BridgeDefinedField bridgeDefinedField) {
        FieldHelper.ExtendedFieldType type = FieldHelper.getType(bridgeDefinedField);
        if (FieldHelper.ExtendedFieldType.UNKNOWN.equals((Object)type)) {
            throw LOG.unexpectedFieldType(bridgeDefinedField.getType().name(), bridgeDefinedField.getAbsoluteName());
        }
        this.addTypeOptions(bridgeDefinedField.getAbsoluteName(), propertyMapping, type);
    }

    private void addTypeOptions(PropertyMapping fieldMapping, FacetMetadata facetMetadata) {
        FieldHelper.ExtendedFieldType type;
        if (facetMetadata.isEncodingAuto()) {
            this.addTypeOptions(fieldMapping, facetMetadata.getSourceField());
            return;
        }
        switch (facetMetadata.getEncoding()) {
            case DOUBLE: {
                type = FieldHelper.ExtendedFieldType.DOUBLE;
                break;
            }
            case LONG: {
                type = FieldHelper.ExtendedFieldType.LONG;
                break;
            }
            case STRING: {
                type = FieldHelper.ExtendedFieldType.STRING;
                break;
            }
            case AUTO: {
                throw new AssertionFailure("The facet type should have been resolved during bootstrapping");
            }
            default: {
                throw new AssertionFailure("Unexpected facet encoding type '" + facetMetadata.getEncoding() + "' Has the enum been modified?");
            }
        }
        this.addTypeOptions(facetMetadata.getAbsoluteName(), fieldMapping, type);
    }

    private DataType addTypeOptions(String fieldName, PropertyMapping propertyMapping, FieldHelper.ExtendedFieldType extendedType) {
        DataType elasticsearchType;
        ArrayList<String> formats = new ArrayList<String>();
        switch (extendedType) {
            case BOOLEAN: {
                elasticsearchType = DataType.BOOLEAN;
                break;
            }
            case CALENDAR: 
            case DATE: 
            case INSTANT: {
                elasticsearchType = DataType.DATE;
                break;
            }
            case LOCAL_DATE: {
                elasticsearchType = DataType.DATE;
                formats.add("strict_date");
                formats.add("yyyyyyyyy-MM-dd");
                break;
            }
            case LOCAL_DATE_TIME: {
                elasticsearchType = DataType.DATE;
                formats.add("strict_date_hour_minute_second_fraction");
                formats.add("yyyyyyyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS");
                break;
            }
            case LOCAL_TIME: {
                elasticsearchType = DataType.DATE;
                formats.add("strict_hour_minute_second_fraction");
                break;
            }
            case OFFSET_DATE_TIME: {
                elasticsearchType = DataType.DATE;
                formats.add("strict_date_time");
                formats.add("yyyyyyyyy-MM-dd'T'HH:mm:ss.SSSSSSSSSZ");
                break;
            }
            case OFFSET_TIME: {
                elasticsearchType = DataType.DATE;
                formats.add("strict_time");
                break;
            }
            case ZONED_DATE_TIME: {
                elasticsearchType = DataType.DATE;
                formats.add("yyyy-MM-dd'T'HH:mm:ss.SSSZZ'['ZZZ']'");
                formats.add("yyyyyyyyy-MM-dd'T'HH:mm:ss.SSSSSSSSSZZ'['ZZZ']'");
                break;
            }
            case YEAR: {
                elasticsearchType = DataType.DATE;
                formats.add("strict_year");
                formats.add("yyyyyyyyy");
                break;
            }
            case YEAR_MONTH: {
                elasticsearchType = DataType.DATE;
                formats.add("strict_year_month");
                formats.add("yyyyyyyyy-MM");
                break;
            }
            case MONTH_DAY: {
                elasticsearchType = DataType.DATE;
                formats.add("--MM-dd");
                break;
            }
            case INTEGER: {
                elasticsearchType = DataType.INTEGER;
                break;
            }
            case LONG: {
                elasticsearchType = DataType.LONG;
                break;
            }
            case FLOAT: {
                elasticsearchType = DataType.FLOAT;
                break;
            }
            case DOUBLE: {
                elasticsearchType = DataType.DOUBLE;
                break;
            }
            case UNKNOWN_NUMERIC: {
                elasticsearchType = null;
                break;
            }
            default: {
                elasticsearchType = DataType.STRING;
            }
        }
        if (elasticsearchType == null) {
            throw new IncompleteDataException("Field type could not be determined");
        }
        propertyMapping.setType(elasticsearchType);
        if (!formats.isEmpty()) {
            propertyMapping.setFormat(formats);
        }
        return elasticsearchType;
    }

    private void addNullValue(PropertyMapping propertyMapping, DocumentFieldMetadata fieldMetadata) {
        String indexNullAs = fieldMetadata.indexNullAs();
        if (indexNullAs != null) {
            Object convertedValue = ElasticSearchIndexNullAsHelper.getNullValue(fieldMetadata.getAbsoluteName(), propertyMapping.getType(), indexNullAs);
            Gson gson = this.gsonService.getGson();
            propertyMapping.setNullValue(gson.toJsonTree(convertedValue).getAsJsonPrimitive());
        }
    }

    private Set<BridgeDefinedField> getNonEmbeddedBridgeDefinedFields(TypeMetadata type) {
        HashSet<BridgeDefinedField> bridgeDefinedFields = new HashSet<BridgeDefinedField>();
        for (DocumentFieldMetadata documentFieldMetadata : type.getNonEmbeddedDocumentFieldMetadata()) {
            bridgeDefinedFields.addAll(documentFieldMetadata.getBridgeDefinedFields().values());
        }
        return bridgeDefinedFields;
    }

    private static class IncompleteDataException
    extends SearchException {
        public IncompleteDataException(String message) {
            super(message);
        }
    }
}

