/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.bridge.util.impl.ContextualExceptionBridgeHelper;
import org.hibernate.search.elasticsearch.filter.ElasticsearchFilter;
import org.hibernate.search.elasticsearch.impl.ElasticsearchIndexManager;
import org.hibernate.search.elasticsearch.impl.ElasticsearchQueryOptions;
import org.hibernate.search.elasticsearch.impl.ElasticsearchService;
import org.hibernate.search.elasticsearch.impl.EmptyDocumentExtractor;
import org.hibernate.search.elasticsearch.impl.EmptySearchResult;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.elasticsearch.impl.ToElasticsearch;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.util.impl.FieldHelper;
import org.hibernate.search.elasticsearch.util.impl.Window;
import org.hibernate.search.elasticsearch.work.impl.ExplainResult;
import org.hibernate.search.elasticsearch.work.impl.SearchResult;
import org.hibernate.search.elasticsearch.work.impl.builder.SearchWorkBuilder;
import org.hibernate.search.engine.impl.FilterDef;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.metadata.impl.BridgeDefinedField;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.FacetMetadata;
import org.hibernate.search.engine.metadata.impl.PartialDocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.filter.impl.FullTextFilterImpl;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.query.dsl.impl.DiscreteFacetRequest;
import org.hibernate.search.query.dsl.impl.FacetRange;
import org.hibernate.search.query.dsl.impl.RangeFacetRequest;
import org.hibernate.search.query.engine.impl.AbstractHSQuery;
import org.hibernate.search.query.engine.impl.EntityInfoImpl;
import org.hibernate.search.query.engine.impl.FacetComparators;
import org.hibernate.search.query.engine.impl.FacetManagerImpl;
import org.hibernate.search.query.engine.impl.TimeoutManagerImpl;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetSortOrder;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.spatial.DistanceSortField;
import org.hibernate.search.util.impl.CollectionHelper;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchHSQueryImpl
extends AbstractHSQuery {
    private static final JsonParser JSON_PARSER = new JsonParser();
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private static final Pattern DOT = Pattern.compile("\\.");
    private static final String SPATIAL_DISTANCE_FIELD = "_distance";
    private static final int MAX_RESULT_WINDOW_SIZE = 10000;
    private static final Set<String> SUPPORTED_PROJECTION_CONSTANTS = Collections.unmodifiableSet(CollectionHelper.asSet((Object[])new String[]{"__HSearch_id", "_hibernate_class", "__HSearch_Score", "__HSearch_Source", "_HSearch_SpatialDistance", "__HSearch_This", "__HSearch_Took", "__HSearch_TimedOut"}));
    private final JsonObject rawSearchPayload;
    private Integer resultSize;
    private IndexSearcher searcher;
    private SearchResult searchResult;
    private int sortByDistanceIndex = -1;
    private transient FacetManagerImpl facetManager;

    public ElasticsearchHSQueryImpl(JsonObject rawSearchPayload, ExtendedSearchIntegrator extendedIntegrator) {
        super(extendedIntegrator);
        this.rawSearchPayload = rawSearchPayload;
    }

    public HSQuery luceneQuery(Query query) {
        throw LOG.hsQueryLuceneQueryUnsupported();
    }

    public FacetManagerImpl getFacetManager() {
        if (this.facetManager == null) {
            this.facetManager = new FacetManagerImpl((AbstractHSQuery)this);
        }
        return this.facetManager;
    }

    public Query getLuceneQuery() {
        throw LOG.hsQueryLuceneQueryUnsupported();
    }

    public String getQueryString() {
        return this.rawSearchPayload.toString();
    }

    public DocumentExtractor queryDocumentExtractor() {
        IndexSearcher searcher = this.getOrCreateSearcher();
        if (searcher != null) {
            return new ElasticsearchScrollAPIDocumentExtractor(searcher);
        }
        return EmptyDocumentExtractor.get();
    }

    SearchResult getSearchResult() {
        if (this.searchResult == null) {
            this.execute();
        }
        return this.searchResult;
    }

    public int queryResultSize() {
        if (this.searchResult == null) {
            this.execute();
        }
        return this.resultSize;
    }

    public Explanation explain(int documentId) {
        if (this.searchResult == null) {
            this.execute();
        }
        JsonObject hit = this.searchResult.getHits().get(documentId).getAsJsonObject();
        JsonObject explainPayload = JsonBuilder.object().add("query", this.searcher.payload.get("query")).build();
        Object work = this.searcher.elasticsearchService.getWorkFactory().explain(hit.get("_index").getAsString(), hit.get("_type").getAsString(), hit.get("_id").getAsString(), explainPayload).build();
        ExplainResult result = (ExplainResult)this.searcher.elasticsearchService.getWorkProcessor().executeSyncUnsafe(work);
        JsonObject explanation = result.getJsonObject().get("explanation").getAsJsonObject();
        return this.convertExplanation(explanation);
    }

    private Explanation convertExplanation(JsonObject explanation) {
        List details;
        float value = explanation.get("value").getAsFloat();
        String description = explanation.get("description").getAsString();
        JsonElement explanationDetails = explanation.get("details");
        if (explanationDetails != null) {
            details = new ArrayList(explanationDetails.getAsJsonArray().size());
            for (JsonElement detail : explanationDetails.getAsJsonArray()) {
                details.add(this.convertExplanation(detail.getAsJsonObject()));
            }
        } else {
            details = Collections.emptyList();
        }
        return Explanation.match((float)value, (String)description, details);
    }

    protected void clearCachedResults() {
        this.searcher = null;
        this.searchResult = null;
        this.resultSize = null;
    }

    protected TimeoutManagerImpl buildTimeoutManager() {
        return new TimeoutManagerImpl((Object)this.rawSearchPayload, this.timeoutExceptionFactory, this.extendedIntegrator.getTimingSource());
    }

    public List<EntityInfo> queryEntityInfos() {
        if (this.searchResult == null) {
            this.execute();
        }
        JsonArray hits = this.searchResult.getHits();
        ArrayList<EntityInfo> results = new ArrayList<EntityInfo>(hits.size());
        for (JsonElement hit : hits) {
            EntityInfo entityInfo = this.searcher.convertQueryHit(this.searchResult, hit.getAsJsonObject());
            if (entityInfo == null) continue;
            results.add(entityInfo);
        }
        return results;
    }

    protected Set<String> getSupportedProjectionConstants() {
        return SUPPORTED_PROJECTION_CONSTANTS;
    }

    private void execute() {
        IndexSearcher searcher = this.getOrCreateSearcher();
        this.searchResult = searcher != null ? searcher.search() : EmptySearchResult.get();
        this.resultSize = this.searchResult.getTotalHitCount();
    }

    private IndexSearcher getOrCreateSearcher() {
        if (this.searcher != null) {
            return this.searcher;
        }
        ElasticsearchService elasticsearchService = null;
        HashMap entityTypesByName = new HashMap();
        HashSet<String> indexNames = new HashSet<String>();
        Iterable<Class<?>> queriedEntityTypes = this.getQueriedEntityTypes();
        for (Class<?> queriedEntityType : queriedEntityTypes) {
            IndexManager[] indexManagers;
            entityTypesByName.put(queriedEntityType.getName(), queriedEntityType);
            EntityIndexBinding binding = this.extendedIntegrator.getIndexBinding(queriedEntityType);
            for (IndexManager indexManager : indexManagers = binding.getIndexManagers()) {
                if (!(indexManager instanceof ElasticsearchIndexManager)) {
                    throw LOG.cannotRunEsQueryTargetingEntityIndexedWithNonEsIndexManager(queriedEntityType, this.rawSearchPayload.toString());
                }
                ElasticsearchIndexManager esIndexManager = (ElasticsearchIndexManager)indexManager;
                indexNames.add(esIndexManager.getActualIndexName());
                if (elasticsearchService == null) {
                    elasticsearchService = esIndexManager.getElasticsearchService();
                    continue;
                }
                if (elasticsearchService == esIndexManager.getElasticsearchService()) continue;
                throw new AssertionFailure("Found two index managers refering to two different ElasticsearchService instances");
            }
        }
        if (indexNames.isEmpty()) {
            return null;
        }
        this.searcher = new IndexSearcher(elasticsearchService, entityTypesByName, indexNames);
        return this.searcher;
    }

    private Iterable<Class<?>> getQueriedEntityTypes() {
        if (this.indexedTargetedEntities == null || this.indexedTargetedEntities.isEmpty()) {
            Set<Class<?>> indexBindings = this.extendedIntegrator.getIndexBindings().keySet();
            if (indexBindings.isEmpty()) {
                throw LOG.queryWithNoIndexedType();
            }
            return indexBindings;
        }
        return this.indexedTargetedEntities;
    }

    protected void extractFacetResults() {
        SearchResult searchResult = this.getSearchResult();
        JsonObject aggregations = searchResult.getAggregations();
        if (aggregations == null) {
            return;
        }
        HashMap<String, List<Facet>> results = new HashMap<String, List<Facet>>();
        for (FacetingRequest facetRequest : this.getFacetManager().getFacetRequests().values()) {
            List<Facet> facets;
            if (facetRequest instanceof DiscreteFacetRequest) {
                facets = this.updateStringFacets(aggregations, (DiscreteFacetRequest)facetRequest);
            } else {
                facets = this.updateRangeFacets(aggregations, (RangeFacetRequest)facetRequest);
                if (!FacetSortOrder.RANGE_DEFINITION_ORDER.equals((Object)facetRequest.getSort())) {
                    Collections.sort(facets, FacetComparators.get((FacetSortOrder)facetRequest.getSort()));
                }
            }
            results.put(facetRequest.getFacetingName(), facets);
        }
        this.getFacetManager().setFacetResults(results);
    }

    private List<Facet> updateRangeFacets(JsonObject aggregations, RangeFacetRequest<?> facetRequest) {
        if (!(ReflectionHelper.isIntegerType((Class)facetRequest.getFacetValueType()) || Date.class.isAssignableFrom(facetRequest.getFacetValueType()) || ReflectionHelper.isFloatingPointType((Class)facetRequest.getFacetValueType()))) {
            throw LOG.unsupportedFacetRangeParameter(facetRequest.getFacetValueType().getName());
        }
        ArrayList<Facet> facets = new ArrayList<Facet>();
        for (FacetRange facetRange : facetRequest.getFacetRangeList()) {
            int docCount;
            JsonElement aggregation = aggregations.get(facetRequest.getFacetingName() + "-" + facetRange.getIdentifier());
            if (aggregation == null || (docCount = aggregation.getAsJsonObject().get("doc_count").getAsInt()) == 0 && !facetRequest.hasZeroCountsIncluded()) continue;
            facets.add(facetRequest.createFacet(facetRange.getRangeString(), docCount));
        }
        return facets;
    }

    private List<Facet> updateStringFacets(JsonObject aggregations, DiscreteFacetRequest facetRequest) {
        JsonElement aggregation = aggregations.get(facetRequest.getFacetingName());
        if (aggregation == null) {
            return Collections.emptyList();
        }
        if (this.isNested(facetRequest)) {
            aggregation = aggregation.getAsJsonObject().get(facetRequest.getFacetingName());
        }
        if (aggregation == null) {
            return Collections.emptyList();
        }
        ArrayList<Facet> facets = new ArrayList<Facet>();
        for (JsonElement bucket : aggregation.getAsJsonObject().get("buckets").getAsJsonArray()) {
            facets.add(facetRequest.createFacet(bucket.getAsJsonObject().get("key").getAsString(), bucket.getAsJsonObject().get("doc_count").getAsInt()));
        }
        return facets;
    }

    private JsonObject buildFullTextFilter(FullTextFilterImpl fullTextFilter) {
        FilterDef def = this.extendedIntegrator.getFilterDefinition(fullTextFilter.getName());
        if (this.isPreQueryFilterOnly(def)) {
            return null;
        }
        Object filterOrFactory = this.createFilterInstance(fullTextFilter, def);
        return this.createFullTextFilter(def, filterOrFactory);
    }

    protected JsonObject createFullTextFilter(FilterDef def, Object filterOrFactory) {
        JsonObject jsonFilter;
        if (def.getFactoryMethod() != null) {
            try {
                Object candidateFilter = def.getFactoryMethod().invoke(filterOrFactory, new Object[0]);
                if (candidateFilter instanceof Filter) {
                    jsonFilter = ToElasticsearch.fromLuceneFilter((Filter)candidateFilter);
                }
                if (candidateFilter instanceof ElasticsearchFilter) {
                    jsonFilter = JSON_PARSER.parse(((ElasticsearchFilter)candidateFilter).getJsonFilter()).getAsJsonObject();
                }
                throw LOG.filterFactoryMethodReturnsUnsupportedType(def.getImpl().getName(), def.getFactoryMethod().getName());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw LOG.filterFactoryMethodInaccessible(def.getImpl().getName(), def.getFactoryMethod().getName(), e);
            }
        } else if (filterOrFactory instanceof Filter) {
            jsonFilter = ToElasticsearch.fromLuceneFilter((Filter)filterOrFactory);
        } else if (filterOrFactory instanceof ElasticsearchFilter) {
            jsonFilter = JSON_PARSER.parse(((ElasticsearchFilter)filterOrFactory).getJsonFilter()).getAsJsonObject();
        } else {
            throw LOG.filterHasUnsupportedType(filterOrFactory == null ? null : filterOrFactory.getClass().getName());
        }
        return jsonFilter;
    }

    private boolean isNested(DiscreteFacetRequest facetRequest) {
        return false;
    }

    private boolean isPartOfProjectedFields(String projectionName) {
        if (this.projectedFields == null) {
            return false;
        }
        for (String projectedField : this.projectedFields) {
            if (!projectionName.equals(projectedField)) continue;
            return true;
        }
        return false;
    }

    private class ElasticsearchScrollAPIDocumentExtractor
    implements DocumentExtractor {
        private final IndexSearcher searcher;
        private final Integer queryIndexLimit;
        private String scrollId;
        private Integer totalResultCount;
        private final Window<EntityInfo> results;

        private ElasticsearchScrollAPIDocumentExtractor(IndexSearcher searcher) {
            this.searcher = searcher;
            this.queryIndexLimit = ElasticsearchHSQueryImpl.this.maxResults == null ? null : Integer.valueOf(ElasticsearchHSQueryImpl.this.firstResult + ElasticsearchHSQueryImpl.this.maxResults);
            ElasticsearchQueryOptions queryOptions = searcher.getQueryOptions();
            this.results = new Window(0, queryOptions.getScrollBacktrackingWindowSize() + queryOptions.getScrollFetchSize());
        }

        public EntityInfo extract(int index) throws IOException {
            int maxIndex;
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index must be >= 0");
            }
            if (index < this.results.start()) {
                throw LOG.backtrackingWindowOverflow(this.searcher.getQueryOptions().getScrollBacktrackingWindowSize(), this.results.start(), index);
            }
            if (this.totalResultCount == null) {
                this.initResults();
            }
            if ((maxIndex = this.getMaxIndex()) < index) {
                throw new IndexOutOfBoundsException("Index must be <= " + maxIndex);
            }
            boolean fetchMayReturnResults = true;
            while (this.results.start() + this.results.size() <= index && fetchMayReturnResults) {
                fetchMayReturnResults = this.fetchNextResults();
            }
            return this.results.get(index);
        }

        public int getFirstIndex() {
            return ElasticsearchHSQueryImpl.this.firstResult;
        }

        public int getMaxIndex() {
            if (this.totalResultCount == null) {
                this.initResults();
            }
            if (this.queryIndexLimit == null) {
                return this.totalResultCount - 1;
            }
            return Math.min(this.totalResultCount, this.queryIndexLimit) - 1;
        }

        public void close() {
            if (this.scrollId != null) {
                this.searcher.clearScroll(this.scrollId);
                this.scrollId = null;
                this.totalResultCount = null;
                this.results.clear();
            }
        }

        public TopDocs getTopDocs() {
            throw LOG.documentExtractorTopDocsUnsupported();
        }

        private void initResults() {
            SearchResult searchResult = this.searcher.searchWithScrollEnabled();
            this.totalResultCount = searchResult.getTotalHitCount();
            this.extractWindow(searchResult);
        }

        private boolean fetchNextResults() {
            if (this.totalResultCount <= this.results.start() + this.results.size()) {
                return false;
            }
            SearchResult searchResult = this.searcher.scroll(this.scrollId);
            return this.extractWindow(searchResult);
        }

        private boolean extractWindow(SearchResult searchResult) {
            boolean fetchedAtLeastOne = false;
            this.scrollId = searchResult.getScrollId();
            JsonArray hits = searchResult.getHits();
            for (JsonElement hit : hits) {
                EntityInfo converted = this.searcher.convertQueryHit(searchResult, hit.getAsJsonObject());
                if (converted == null) continue;
                this.results.add(converted);
                fetchedAtLeastOne = true;
            }
            return fetchedAtLeastOne;
        }
    }

    private static class FailingOneWayFieldBridgeProjection
    extends FieldProjection {
        private final String absoluteName;
        private final Class<?> fieldBridgeClass;

        public FailingOneWayFieldBridgeProjection(String absoluteName, Class<?> fieldBridgeClass) {
            this.absoluteName = absoluteName;
            this.fieldBridgeClass = fieldBridgeClass;
        }

        @Override
        public Object convertHit(JsonObject hit, ConversionContext conversionContext) {
            throw LOG.projectingFieldWithoutTwoWayFieldBridge(this.absoluteName, this.fieldBridgeClass);
        }
    }

    private static class JsonDrivenProjection
    extends FieldProjection {
        private final String absoluteName;

        public JsonDrivenProjection(String absoluteName) {
            this.absoluteName = absoluteName;
        }

        @Override
        public Object convertHit(JsonObject hit, ConversionContext conversionContext) {
            JsonElement value = this.extractFieldValue(hit.get("_source").getAsJsonObject(), this.absoluteName);
            if (value == null || value.isJsonNull()) {
                return null;
            }
            if (!value.isJsonPrimitive()) {
                throw LOG.unsupportedProjectionOfNonJsonPrimitiveFields(value);
            }
            JsonPrimitive primitive = value.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean();
            }
            if (primitive.isNumber()) {
                return primitive.getAsNumber();
            }
            if (primitive.isString()) {
                return primitive.getAsString();
            }
            return primitive.toString();
        }
    }

    private static class PrimitiveProjection
    extends FieldProjection {
        private final TypeMetadata rootTypeMetadata;
        private final String absoluteName;
        private final FieldHelper.ExtendedFieldType fieldType;

        public PrimitiveProjection(TypeMetadata rootTypeMetadata, String absoluteName, FieldHelper.ExtendedFieldType fieldType) {
            this.rootTypeMetadata = rootTypeMetadata;
            this.absoluteName = absoluteName;
            this.fieldType = fieldType;
        }

        public void addDocumentField(Document tmp, JsonObject hit, ConversionContext conversionContext) {
            JsonElement jsonValue = this.extractFieldValue(hit.get("_source").getAsJsonObject(), this.absoluteName);
            if (jsonValue == null || jsonValue.isJsonNull()) {
                return;
            }
            switch (this.fieldType) {
                case INTEGER: {
                    tmp.add((IndexableField)new IntField(this.absoluteName, jsonValue.getAsInt(), Field.Store.NO));
                    break;
                }
                case LONG: {
                    tmp.add((IndexableField)new LongField(this.absoluteName, jsonValue.getAsLong(), Field.Store.NO));
                    break;
                }
                case FLOAT: {
                    tmp.add((IndexableField)new FloatField(this.absoluteName, jsonValue.getAsFloat(), Field.Store.NO));
                    break;
                }
                case DOUBLE: {
                    tmp.add((IndexableField)new DoubleField(this.absoluteName, jsonValue.getAsDouble(), Field.Store.NO));
                    break;
                }
                case UNKNOWN_NUMERIC: {
                    throw LOG.unexpectedNumericEncodingType(this.rootTypeMetadata.getType().getName(), this.absoluteName);
                }
                case BOOLEAN: {
                    tmp.add((IndexableField)new StringField(this.absoluteName, String.valueOf(jsonValue.getAsBoolean()), Field.Store.NO));
                    break;
                }
                default: {
                    tmp.add((IndexableField)new StringField(this.absoluteName, jsonValue.getAsString(), Field.Store.NO));
                }
            }
        }

        @Override
        public Object convertHit(JsonObject hit, ConversionContext conversionContext) {
            JsonElement jsonValue = this.extractFieldValue(hit.get("_source").getAsJsonObject(), this.absoluteName);
            if (jsonValue == null || jsonValue.isJsonNull()) {
                return null;
            }
            switch (this.fieldType) {
                case INTEGER: {
                    return jsonValue.getAsInt();
                }
                case LONG: {
                    return jsonValue.getAsLong();
                }
                case FLOAT: {
                    return Float.valueOf(jsonValue.getAsFloat());
                }
                case DOUBLE: {
                    return jsonValue.getAsDouble();
                }
                case UNKNOWN_NUMERIC: {
                    throw LOG.unexpectedNumericEncodingType(this.rootTypeMetadata.getType().getName(), this.absoluteName);
                }
                case BOOLEAN: {
                    return jsonValue.getAsBoolean();
                }
            }
            return jsonValue.getAsString();
        }
    }

    private static class TwoWayFieldBridgeProjection
    extends FieldProjection {
        private final String absoluteName;
        private final TwoWayFieldBridge bridge;
        private final PrimitiveProjection defaultFieldProjection;
        private final List<PrimitiveProjection> bridgeDefinedFieldsProjections;

        public TwoWayFieldBridgeProjection(String absoluteName, TwoWayFieldBridge bridge, PrimitiveProjection defaultFieldProjection, List<PrimitiveProjection> bridgeDefinedFieldsProjections) {
            this.absoluteName = absoluteName;
            this.bridge = bridge;
            this.defaultFieldProjection = defaultFieldProjection;
            this.bridgeDefinedFieldsProjections = bridgeDefinedFieldsProjections;
        }

        @Override
        public Object convertHit(JsonObject hit, ConversionContext conversionContext) {
            return this.convertFieldValue(hit, conversionContext);
        }

        private Object convertFieldValue(JsonObject hit, ConversionContext conversionContext) {
            Document tmp = new Document();
            this.defaultFieldProjection.addDocumentField(tmp, hit, conversionContext);
            for (PrimitiveProjection subProjection : this.bridgeDefinedFieldsProjections) {
                subProjection.addDocumentField(tmp, hit, conversionContext);
            }
            return conversionContext.twoWayConversionContext(this.bridge).get(this.absoluteName, tmp);
        }
    }

    private static abstract class FieldProjection {
        private FieldProjection() {
        }

        public abstract Object convertHit(JsonObject var1, ConversionContext var2);

        protected final JsonElement extractFieldValue(JsonObject parent, String projectedField) {
            String field = projectedField;
            if (FieldHelper.isEmbeddedField(projectedField)) {
                String[] parts = DOT.split(projectedField);
                field = parts[parts.length - 1];
                for (int i = 0; i < parts.length - 1; ++i) {
                    JsonElement newParent = parent.get(parts[i]);
                    if (newParent == null) {
                        return null;
                    }
                    parent = newParent.getAsJsonObject();
                }
            }
            return parent.getAsJsonObject().get(field);
        }
    }

    private class IndexSearcher {
        private final ElasticsearchService elasticsearchService;
        private final Map<String, Class<?>> entityTypesByName;
        private final Set<String> indexNames;
        private final ElasticsearchQueryOptions queryOptions;
        private final Map<Class<?>, FieldProjection> idProjectionByEntityType = new HashMap();
        private final Map<Class<?>, FieldProjection[]> fieldProjectionsByEntityType = new HashMap();
        private final JsonObject payload;

        private IndexSearcher(ElasticsearchService elasticsearchService, Map<String, Class<?>> entityTypesByName, Set<String> indexNames) {
            this.elasticsearchService = elasticsearchService;
            this.entityTypesByName = entityTypesByName;
            this.indexNames = indexNames;
            JsonArray typeFilters = new JsonArray();
            for (String typeName : entityTypesByName.keySet()) {
                typeFilters.add((JsonElement)this.getEntityTypeFilter(typeName));
            }
            this.queryOptions = elasticsearchService.getQueryOptions();
            JsonObject filteredQuery = this.getFilteredQuery(ElasticsearchHSQueryImpl.this.rawSearchPayload.get("query"), typeFilters);
            JsonBuilder.Object payloadBuilder = JsonBuilder.object();
            payloadBuilder.add("query", (JsonElement)filteredQuery);
            this.addProjections(payloadBuilder);
            if (!ElasticsearchHSQueryImpl.this.getFacetManager().getFacetRequests().isEmpty()) {
                JsonBuilder.Object facets = JsonBuilder.object();
                for (Map.Entry facetRequestEntry : ElasticsearchHSQueryImpl.this.getFacetManager().getFacetRequests().entrySet()) {
                    this.addFacetingRequest(facets, (FacetingRequest)facetRequestEntry.getValue());
                }
                payloadBuilder.add("aggregations", facets);
            }
            ElasticsearchHSQueryImpl.this.sortByDistanceIndex = this.getSortByDistanceIndex();
            this.addScriptFields(payloadBuilder);
            if (ElasticsearchHSQueryImpl.this.sort != null) {
                ElasticsearchHSQueryImpl.this.validateSortFields(ElasticsearchHSQueryImpl.this.extendedIntegrator, ElasticsearchHSQueryImpl.this.getQueriedEntityTypes());
                payloadBuilder.add("sort", (JsonElement)ToElasticsearch.fromLuceneSort(ElasticsearchHSQueryImpl.this.sort));
            }
            this.payload = payloadBuilder.build();
        }

        private JsonObject getFilteredQuery(JsonElement originalQuery, JsonArray typeFilters) {
            JsonArray filters = new JsonArray();
            JsonObject tenantFilter = this.getTenantIdFilter();
            if (tenantFilter != null) {
                filters.add((JsonElement)tenantFilter);
            }
            filters.add((JsonElement)ToElasticsearch.condition("should", typeFilters));
            for (Query query : ElasticsearchHSQueryImpl.this.getFacetManager().getFacetFilters().getFilterQueries()) {
                filters.add((JsonElement)ToElasticsearch.fromLuceneQuery(query));
            }
            if (ElasticsearchHSQueryImpl.this.userFilter != null) {
                filters.add((JsonElement)ToElasticsearch.fromLuceneFilter(ElasticsearchHSQueryImpl.this.userFilter));
            }
            if (!ElasticsearchHSQueryImpl.this.filterDefinitions.isEmpty()) {
                for (FullTextFilterImpl fullTextFilter : ElasticsearchHSQueryImpl.this.filterDefinitions.values()) {
                    JsonObject filter = ElasticsearchHSQueryImpl.this.buildFullTextFilter(fullTextFilter);
                    if (filter == null) continue;
                    filters.add((JsonElement)filter);
                }
            }
            JsonBuilder.Object boolBuilder = JsonBuilder.object();
            if (originalQuery != null && !originalQuery.isJsonNull()) {
                boolBuilder.add("must", originalQuery);
            }
            if (filters.size() == 1) {
                boolBuilder.add("filter", filters.get(0));
            } else {
                boolBuilder.add("filter", (JsonElement)filters);
            }
            return JsonBuilder.object().add("bool", (JsonElement)boolBuilder.build()).build();
        }

        private JsonObject getEntityTypeFilter(String name) {
            JsonObject value = new JsonObject();
            value.addProperty("value", name);
            JsonObject type = new JsonObject();
            type.add("type", (JsonElement)value);
            return type;
        }

        private JsonObject getTenantIdFilter() {
            if (ElasticsearchHSQueryImpl.this.tenantId == null) {
                return null;
            }
            JsonObject value = new JsonObject();
            value.addProperty("__HSearch_TenantId", ElasticsearchHSQueryImpl.this.tenantId);
            JsonObject tenantFilter = new JsonObject();
            tenantFilter.add("term", (JsonElement)value);
            return tenantFilter;
        }

        private void addProjections(JsonBuilder.Object payloadBuilder) {
            JsonArray array;
            boolean includeAllSource = false;
            JsonBuilder.Array builder = JsonBuilder.array();
            Iterable queriedEntityTypes = ElasticsearchHSQueryImpl.this.getQueriedEntityTypes();
            for (Class entityType : queriedEntityTypes) {
                EntityIndexBinding binding = ElasticsearchHSQueryImpl.this.extendedIntegrator.getIndexBinding(entityType);
                DocumentBuilderIndexedEntity documentBuilder = binding.getDocumentBuilder();
                String idFieldName = documentBuilder.getIdFieldName();
                TypeMetadata typeMetadata = documentBuilder.getTypeMetadata();
                FieldProjection projection = this.createProjection(builder, typeMetadata, idFieldName);
                this.idProjectionByEntityType.put(entityType, projection);
            }
            if (ElasticsearchHSQueryImpl.this.projectedFields != null) {
                block16: for (int i = 0; i < ElasticsearchHSQueryImpl.this.projectedFields.length; ++i) {
                    String projectedField = ElasticsearchHSQueryImpl.this.projectedFields[i];
                    if (projectedField == null) continue;
                    switch (projectedField) {
                        case "__HSearch_Source": {
                            includeAllSource = true;
                            continue block16;
                        }
                        case "__HSearch_Score": {
                            payloadBuilder.addProperty("track_scores", true);
                            continue block16;
                        }
                        case "__HSearch_id": 
                        case "__HSearch_This": 
                        case "_hibernate_class": 
                        case "_HSearch_SpatialDistance": 
                        case "__HSearch_Took": 
                        case "__HSearch_TimedOut": {
                            continue block16;
                        }
                        default: {
                            for (Class entityType : queriedEntityTypes) {
                                EntityIndexBinding binding = ElasticsearchHSQueryImpl.this.extendedIntegrator.getIndexBinding(entityType);
                                TypeMetadata typeMetadata = binding.getDocumentBuilder().getTypeMetadata();
                                FieldProjection projection = this.createProjection(builder, typeMetadata, projectedField);
                                FieldProjection[] projectionsForType = this.fieldProjectionsByEntityType.get(entityType);
                                if (projectionsForType == null) {
                                    projectionsForType = new FieldProjection[ElasticsearchHSQueryImpl.this.projectedFields.length];
                                    this.fieldProjectionsByEntityType.put(entityType, projectionsForType);
                                }
                                projectionsForType[i] = projection;
                            }
                        }
                    }
                }
            }
            Object filter = includeAllSource ? new JsonPrimitive("*") : ((array = builder.build()).size() > 0 ? array : new JsonPrimitive(Boolean.valueOf(false)));
            payloadBuilder.add("_source", (JsonElement)filter);
        }

        private FieldProjection createProjection(JsonBuilder.Array sourceFilterCollector, TypeMetadata rootTypeMetadata, String projectedField) {
            DocumentFieldMetadata fieldMetadata = rootTypeMetadata.getDocumentFieldMetadataFor(projectedField);
            if (fieldMetadata != null) {
                return this.createProjection(sourceFilterCollector, rootTypeMetadata, fieldMetadata);
            }
            BridgeDefinedField bridgeDefinedField = rootTypeMetadata.getBridgeDefinedFieldMetadataFor(projectedField);
            if (bridgeDefinedField != null) {
                return this.createProjection(sourceFilterCollector, rootTypeMetadata, bridgeDefinedField);
            }
            sourceFilterCollector.add((JsonElement)new JsonPrimitive(projectedField));
            return new JsonDrivenProjection(projectedField);
        }

        private FieldProjection createProjection(JsonBuilder.Array sourceFilterCollector, TypeMetadata rootTypeMetadata, DocumentFieldMetadata fieldMetadata) {
            String absoluteName = fieldMetadata.getAbsoluteName();
            FieldBridge fieldBridge = fieldMetadata.getFieldBridge();
            FieldHelper.ExtendedFieldType type = FieldHelper.getType((PartialDocumentFieldMetadata)fieldMetadata);
            if (FieldHelper.ExtendedFieldType.BOOLEAN.equals((Object)type)) {
                sourceFilterCollector.add((JsonElement)new JsonPrimitive(absoluteName));
                return new PrimitiveProjection(rootTypeMetadata, absoluteName, type);
            }
            if (fieldBridge instanceof TwoWayFieldBridge) {
                sourceFilterCollector.add((JsonElement)new JsonPrimitive(absoluteName));
                PrimitiveProjection defaultFieldProjection = new PrimitiveProjection(rootTypeMetadata, absoluteName, type);
                Collection bridgeDefinedFields = fieldMetadata.getBridgeDefinedFields().values();
                ArrayList bridgeDefinedFieldsProjections = CollectionHelper.newArrayList((int)bridgeDefinedFields.size());
                for (BridgeDefinedField bridgeDefinedField : bridgeDefinedFields) {
                    PrimitiveProjection primitiveProjection = this.createProjection(sourceFilterCollector, rootTypeMetadata, bridgeDefinedField);
                    bridgeDefinedFieldsProjections.add(primitiveProjection);
                }
                return new TwoWayFieldBridgeProjection(absoluteName, (TwoWayFieldBridge)fieldBridge, defaultFieldProjection, bridgeDefinedFieldsProjections);
            }
            return new FailingOneWayFieldBridgeProjection(absoluteName, fieldBridge.getClass());
        }

        private PrimitiveProjection createProjection(JsonBuilder.Array sourceFilterCollector, TypeMetadata rootTypeMetadata, BridgeDefinedField bridgeDefinedField) {
            String absoluteName = bridgeDefinedField.getAbsoluteName();
            FieldHelper.ExtendedFieldType type = FieldHelper.getType(bridgeDefinedField);
            sourceFilterCollector.add((JsonElement)new JsonPrimitive(absoluteName));
            return new PrimitiveProjection(rootTypeMetadata, absoluteName, type);
        }

        private void addFacetingRequest(JsonBuilder.Object facets, FacetingRequest facetingRequest) {
            String facetFieldAbsoluteName = facetingRequest.getFieldName();
            FacetMetadata facetMetadata = null;
            for (Class entityType : ElasticsearchHSQueryImpl.this.getQueriedEntityTypes()) {
                EntityIndexBinding binding = ElasticsearchHSQueryImpl.this.extendedIntegrator.getIndexBinding(entityType);
                TypeMetadata typeMetadata = binding.getDocumentBuilder().getTypeMetadata();
                facetMetadata = typeMetadata.getFacetMetadataFor(facetFieldAbsoluteName);
                if (facetMetadata == null) continue;
                break;
            }
            if (facetMetadata == null) {
                throw LOG.unknownFieldNameForFaceting(facetingRequest.getFacetingName(), facetingRequest.getFieldName());
            }
            String sourceFieldAbsoluteName = facetMetadata.getSourceField().getAbsoluteName();
            String facetSubfieldName = facetMetadata.getPath().getRelativeName();
            ToElasticsearch.addFacetingRequest(facets, facetingRequest, sourceFieldAbsoluteName, facetSubfieldName);
        }

        private int getSortByDistanceIndex() {
            int i = 0;
            if (ElasticsearchHSQueryImpl.this.sort != null) {
                for (SortField sortField : ElasticsearchHSQueryImpl.this.sort.getSort()) {
                    if (sortField instanceof DistanceSortField) {
                        return i;
                    }
                    ++i;
                }
            }
            return -1;
        }

        private boolean isSortedByDistance() {
            return ElasticsearchHSQueryImpl.this.sortByDistanceIndex >= 0;
        }

        private void addScriptFields(JsonBuilder.Object payloadBuilder) {
            if (ElasticsearchHSQueryImpl.this.isPartOfProjectedFields("_HSearch_SpatialDistance") && !this.isSortedByDistance()) {
                payloadBuilder.add("script_fields", JsonBuilder.object().add(ElasticsearchHSQueryImpl.SPATIAL_DISTANCE_FIELD, JsonBuilder.object().add("script", JsonBuilder.object().add("params", JsonBuilder.object().addProperty("lat", ElasticsearchHSQueryImpl.this.spatialSearchCenter.getLatitude()).addProperty("lon", ElasticsearchHSQueryImpl.this.spatialSearchCenter.getLongitude())).addProperty("inline", "doc['" + ElasticsearchHSQueryImpl.this.spatialFieldName + "'] ? doc['" + ElasticsearchHSQueryImpl.this.spatialFieldName + "'].arcDistance(lat,lon)*0.001 : null").addProperty("lang", "groovy"))));
            }
        }

        SearchResult search() {
            return this.search(false);
        }

        SearchResult searchWithScrollEnabled() {
            return this.search(true);
        }

        private SearchResult search(boolean enableScrolling) {
            SearchWorkBuilder builder = this.elasticsearchService.getWorkFactory().search(this.payload).indexes(this.indexNames);
            if (enableScrolling) {
                builder.scrolling(this.getQueryOptions().getScrollFetchSize(), this.getQueryOptions().getScrollTimeout());
            } else {
                builder.paging(ElasticsearchHSQueryImpl.this.firstResult, ElasticsearchHSQueryImpl.this.maxResults != null ? ElasticsearchHSQueryImpl.this.maxResults : 10000 - ElasticsearchHSQueryImpl.this.firstResult);
            }
            Object work = builder.build();
            return (SearchResult)this.elasticsearchService.getWorkProcessor().executeSyncUnsafe(work);
        }

        private ElasticsearchQueryOptions getQueryOptions() {
            return this.queryOptions;
        }

        SearchResult scroll(String scrollId) {
            ElasticsearchQueryOptions queryOptions = this.getQueryOptions();
            Object work = this.elasticsearchService.getWorkFactory().scroll(scrollId, queryOptions.getScrollTimeout()).build();
            return (SearchResult)this.elasticsearchService.getWorkProcessor().executeSyncUnsafe(work);
        }

        void clearScroll(String scrollId) {
            Object work = this.elasticsearchService.getWorkFactory().clearScroll(scrollId).build();
            this.elasticsearchService.getWorkProcessor().executeSyncUnsafe(work);
        }

        EntityInfo convertQueryHit(SearchResult searchResult, JsonObject hit) {
            String type = hit.get("_type").getAsString();
            Class<?> clazz = this.entityTypesByName.get(type);
            if (clazz == null) {
                LOG.warnf("Found unknown type in Elasticsearch index: " + type, new Object[0]);
                return null;
            }
            EntityIndexBinding binding = ElasticsearchHSQueryImpl.this.extendedIntegrator.getIndexBinding(clazz);
            ContextualExceptionBridgeHelper conversionContext = new ContextualExceptionBridgeHelper();
            conversionContext.setClass(clazz);
            FieldProjection idProjection = this.idProjectionByEntityType.get(clazz);
            Object id = idProjection.convertHit(hit, (ConversionContext)conversionContext);
            Object[] projections = null;
            if (ElasticsearchHSQueryImpl.this.projectedFields != null) {
                projections = new Object[ElasticsearchHSQueryImpl.this.projectedFields.length];
                block20: for (int i = 0; i < projections.length; ++i) {
                    String field = ElasticsearchHSQueryImpl.this.projectedFields[i];
                    if (field == null) continue;
                    switch (field) {
                        case "__HSearch_Source": {
                            projections[i] = hit.getAsJsonObject().get("_source").toString();
                            continue block20;
                        }
                        case "__HSearch_id": {
                            projections[i] = id;
                            continue block20;
                        }
                        case "_hibernate_class": {
                            projections[i] = clazz;
                            continue block20;
                        }
                        case "__HSearch_Score": {
                            projections[i] = Float.valueOf(hit.getAsJsonObject().get("_score").getAsFloat());
                            continue block20;
                        }
                        case "_HSearch_SpatialDistance": {
                            JsonElement distance = null;
                            if (this.isSortedByDistance()) {
                                distance = hit.getAsJsonObject().get("sort").getAsJsonArray().get(ElasticsearchHSQueryImpl.this.sortByDistanceIndex);
                            } else {
                                JsonElement fields = hit.getAsJsonObject().get("fields");
                                if (fields != null) {
                                    distance = hit.getAsJsonObject().get("fields").getAsJsonObject().get(ElasticsearchHSQueryImpl.SPATIAL_DISTANCE_FIELD);
                                }
                            }
                            if (distance != null && distance.isJsonArray()) {
                                JsonArray array = distance.getAsJsonArray();
                                JsonElement jsonElement = distance = array.size() >= 1 ? array.get(0) : null;
                            }
                            if (distance == null || distance.isJsonNull()) {
                                projections[i] = null;
                                continue block20;
                            }
                            Double distanceAsDouble = distance.getAsDouble();
                            if (distanceAsDouble == Double.MAX_VALUE || distanceAsDouble.isInfinite()) {
                                projections[i] = null;
                                continue block20;
                            }
                            projections[i] = distance.getAsDouble();
                            continue block20;
                        }
                        case "__HSearch_Took": {
                            projections[i] = searchResult.getTook();
                            continue block20;
                        }
                        case "__HSearch_TimedOut": {
                            projections[i] = searchResult.getTimedOut();
                            continue block20;
                        }
                        case "__HSearch_This": {
                            projections[i] = EntityInfo.ENTITY_PLACEHOLDER;
                            continue block20;
                        }
                        default: {
                            FieldProjection projection = this.fieldProjectionsByEntityType.get(clazz)[i];
                            projections[i] = projection.convertHit(hit, (ConversionContext)conversionContext);
                        }
                    }
                }
            }
            return new EntityInfoImpl(clazz, binding.getDocumentBuilder().getIdPropertyName(), (Serializable)id, projections);
        }
    }
}

