/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.work.impl;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.client.Response;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.SimpleElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.builder.FlushWorkBuilder;
import org.hibernate.search.elasticsearch.work.impl.builder.RefreshWorkBuilder;
import org.hibernate.search.elasticsearch.work.impl.factory.ElasticsearchWorkFactory;

public class ES5FlushWork
extends SimpleElasticsearchWork<Void> {
    private final ElasticsearchWork<?> refreshWork;

    protected ES5FlushWork(Builder builder) {
        super(builder);
        this.refreshWork = builder.buildRefreshWork();
    }

    @Override
    protected void afterSuccess(ElasticsearchWorkExecutionContext executionContext) {
        super.afterSuccess(executionContext);
        this.refreshWork.execute(executionContext);
    }

    @Override
    protected Void generateResult(ElasticsearchWorkExecutionContext context, Response response, JsonObject parsedResponseBody) {
        return null;
    }

    public static class Builder
    extends SimpleElasticsearchWork.Builder<Builder>
    implements FlushWorkBuilder {
        private final RefreshWorkBuilder refreshWorkBuilder;
        private List<String> indexNames = new ArrayList<String>();

        public Builder(ElasticsearchWorkFactory workFactory) {
            super(null, DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.refreshWorkBuilder = workFactory.refresh();
        }

        @Override
        public Builder index(String indexName) {
            this.indexNames.add(indexName);
            this.refreshWorkBuilder.index(indexName);
            return this;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.post();
            if (!this.indexNames.isEmpty()) {
                builder.multiValuedPathComponent(this.indexNames);
            }
            builder.pathComponent("_flush");
            return builder.build();
        }

        protected ElasticsearchWork<?> buildRefreshWork() {
            return this.refreshWorkBuilder.build();
        }

        @Override
        public ES5FlushWork build() {
            return new ES5FlushWork(this);
        }
    }
}

