/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.work.impl;

import com.google.gson.JsonObject;
import org.elasticsearch.client.Response;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.ExplainResult;
import org.hibernate.search.elasticsearch.work.impl.SimpleElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.builder.ExplainWorkBuilder;

public class ExplainWork
extends SimpleElasticsearchWork<ExplainResult> {
    protected ExplainWork(Builder builder) {
        super(builder);
    }

    @Override
    protected ExplainResult generateResult(ElasticsearchWorkExecutionContext context, Response response, JsonObject parsedResponseBody) {
        return new ExplainResultImpl(parsedResponseBody);
    }

    private static class ExplainResultImpl
    implements ExplainResult {
        private final JsonObject jsonObject;

        public ExplainResultImpl(JsonObject jsonObject) {
            this.jsonObject = jsonObject;
        }

        @Override
        public JsonObject getJsonObject() {
            return this.jsonObject;
        }
    }

    public static class Builder
    extends SimpleElasticsearchWork.Builder<Builder>
    implements ExplainWorkBuilder {
        private final String indexName;
        private final String typeName;
        private final String id;
        private final JsonObject payload;

        public Builder(String indexName, String typeName, String id, JsonObject payload) {
            super(null, DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.indexName = indexName;
            this.typeName = typeName;
            this.id = id;
            this.payload = payload;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.get().pathComponent(this.indexName).pathComponent(this.typeName).pathComponent(this.id).pathComponent("_explain").body(this.payload);
            return builder.build();
        }

        @Override
        public ExplainWork build() {
            return new ExplainWork(this);
        }
    }
}

