/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.work.impl;

import com.google.gson.JsonObject;
import org.elasticsearch.client.Response;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.SearchResult;
import org.hibernate.search.elasticsearch.work.impl.SearchWork;
import org.hibernate.search.elasticsearch.work.impl.SimpleElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.builder.ScrollWorkBuilder;

public class ScrollWork
extends SimpleElasticsearchWork<SearchResult> {
    protected ScrollWork(Builder builder) {
        super(builder);
    }

    @Override
    protected SearchResult generateResult(ElasticsearchWorkExecutionContext context, Response response, JsonObject parsedResponseBody) {
        return new SearchWork.SearchResultImpl(parsedResponseBody);
    }

    public static class Builder
    extends SimpleElasticsearchWork.Builder<Builder>
    implements ScrollWorkBuilder {
        private final String scrollId;
        private final String scrollTimeout;

        public Builder(String scrollId, String scrollTimeout) {
            super(null, DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.scrollId = scrollId;
            this.scrollTimeout = scrollTimeout;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.post().pathComponent("_search").pathComponent("scroll").body(JsonBuilder.object().addProperty("scroll_id", this.scrollId).addProperty("scroll", this.scrollTimeout).build());
            return builder.build();
        }

        @Override
        public ScrollWork build() {
            return new ScrollWork(this);
        }
    }
}

