/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.util.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchResponse;
import org.hibernate.search.elasticsearch.gson.impl.GsonProvider;

public class ElasticsearchClientUtils {
    private static final ContentType JSON_CONTENT_TYPE = ContentType.APPLICATION_JSON.withCharset("utf-8");

    private ElasticsearchClientUtils() {
    }

    public static boolean isSuccessCode(int code) {
        return 200 <= code && code < 300;
    }

    public static HttpEntity toEntity(Gson gson, ElasticsearchRequest request) {
        List<JsonObject> bodyParts = request.getBodyParts();
        if (bodyParts.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (JsonObject bodyPart : bodyParts) {
            gson.toJson((JsonElement)bodyPart, (Appendable)builder);
            builder.append("\n");
        }
        return new StringEntity(builder.toString(), JSON_CONTENT_TYPE);
    }

    public static String formatRequest(GsonProvider gsonProvider, ElasticsearchRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append("Method: ").append(request.getMethod()).append("\n");
        sb.append("Path: ").append(request.getPath()).append("\n");
        sb.append("Data:\n");
        sb.append(ElasticsearchClientUtils.formatRequestData(gsonProvider, request));
        sb.append("\n");
        return sb.toString();
    }

    public static String formatRequestData(GsonProvider gsonProvider, ElasticsearchRequest request) {
        List<JsonObject> bodyParts = request.getBodyParts();
        Gson gson = gsonProvider.getGsonPrettyPrinting();
        StringBuilder builder = new StringBuilder();
        for (JsonObject bodyPart : bodyParts) {
            gson.toJson((JsonElement)bodyPart, (Appendable)builder);
            builder.append("\n");
        }
        return builder.toString();
    }

    public static String formatRequestData(GsonProvider gsonProvider, JsonObject body) {
        Gson gson = gsonProvider.getGsonPrettyPrinting();
        return gson.toJson((JsonElement)body);
    }

    public static String formatResponse(GsonProvider gsonProvider, ElasticsearchResponse response) {
        if (response == null) {
            return null;
        }
        JsonObject body = response.getBody();
        StringBuilder sb = new StringBuilder();
        sb.append("Status: ").append(response.getStatusCode()).append(" ").append(response.getStatusMessage()).append("\n");
        sb.append("Error message: ").append(ElasticsearchClientUtils.propertyAsString((JsonElement)body, "error")).append("\n");
        sb.append("Cluster name: ").append(ElasticsearchClientUtils.propertyAsString((JsonElement)body, "cluster_name")).append("\n");
        sb.append("Cluster status: ").append(ElasticsearchClientUtils.propertyAsString((JsonElement)body, "status")).append("\n");
        sb.append("\n");
        JsonElement items = ElasticsearchClientUtils.property(body, "items");
        if (items != null && items.isJsonArray()) {
            for (JsonElement item : items.getAsJsonArray()) {
                for (Map.Entry entry : item.getAsJsonObject().entrySet()) {
                    sb.append("Operation: ").append((String)entry.getKey()).append("\n");
                    JsonElement value = (JsonElement)entry.getValue();
                    sb.append("  Index: ").append(ElasticsearchClientUtils.propertyAsString(value, "_index")).append("\n");
                    sb.append("  Type: ").append(ElasticsearchClientUtils.propertyAsString(value, "_type")).append("\n");
                    sb.append("  Id: ").append(ElasticsearchClientUtils.propertyAsString(value, "_id")).append("\n");
                    sb.append("  Status: ").append(ElasticsearchClientUtils.propertyAsString(value, "status")).append("\n");
                    sb.append("  Error: ").append(ElasticsearchClientUtils.propertyAsString(value, "error")).append("\n");
                }
            }
        }
        return sb.toString();
    }

    private static JsonElement property(JsonObject parent, String name) {
        if (parent == null) {
            return null;
        }
        return parent.get(name);
    }

    private static String propertyAsString(JsonElement parent, String name) {
        if (parent == null || !parent.isJsonObject()) {
            return null;
        }
        JsonElement propretyValue = ElasticsearchClientUtils.property(parent.getAsJsonObject(), name);
        if (propretyValue == null) {
            return null;
        }
        return propretyValue.toString();
    }
}

