/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.work.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchResponse;
import org.hibernate.search.elasticsearch.client.impl.Paths;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.gson.impl.GsonProvider;
import org.hibernate.search.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.util.impl.ElasticsearchClientUtils;
import org.hibernate.search.elasticsearch.work.impl.BulkRequestFailedException;
import org.hibernate.search.elasticsearch.work.impl.BulkableElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkAggregator;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.ForwardingElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.builder.BulkWorkBuilder;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.impl.CollectionHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class BulkWork
implements ElasticsearchWork<Void> {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private static final JsonAccessor<JsonArray> BULK_ITEMS = JsonAccessor.root().property("items").asArray();
    private final ElasticsearchRequest request;
    private final List<BulkableElasticsearchWork<?>> works;
    private final boolean refreshInAPICall;

    protected BulkWork(Builder builder) {
        this.request = builder.buildRequest();
        this.works = new ArrayList(builder.bulkableWorks);
        this.refreshInAPICall = builder.refreshInBulkAPICall;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "works = " + this.works + ", refreshInAPICall = " + this.refreshInAPICall + "]";
    }

    @Override
    public Void execute(ElasticsearchWorkExecutionContext context) {
        if (this.refreshInAPICall) {
            context = new NoIndexDirtyBulkExecutionContext(context);
        }
        GsonProvider gsonProvider = context.getGsonProvider();
        ElasticsearchResponse response = null;
        try {
            response = context.getClient().execute(this.request);
            this.handleResults(context, response);
            return null;
        }
        catch (SearchException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw LOG.elasticsearchRequestFailed(ElasticsearchClientUtils.formatRequest(gsonProvider, this.request), ElasticsearchClientUtils.formatResponse(gsonProvider, response), e);
        }
    }

    @Override
    public void aggregate(ElasticsearchWorkAggregator aggregator) {
        aggregator.addNonBulkable(this);
    }

    @Override
    public Stream<LuceneWork> getLuceneWorks() {
        Stream<LuceneWork> result = Stream.empty();
        for (BulkableElasticsearchWork<?> work : this.works) {
            result = Stream.concat(result, work.getLuceneWorks());
        }
        return result;
    }

    private void handleResults(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        HashMap successfulItems = CollectionHelper.newHashMap((int)this.works.size());
        ArrayList erroneousItems = new ArrayList();
        int i = 0;
        JsonObject parsedResponseBody = response.getBody();
        JsonArray resultItems = BULK_ITEMS.get(parsedResponseBody).orElseGet(JsonArray::new);
        int resultItemsSize = resultItems.size();
        ArrayList<RuntimeException> resultHandlingExceptions = null;
        for (BulkableElasticsearchWork<?> work : this.works) {
            boolean bl;
            JsonObject resultItem = null;
            try {
                resultItem = i < resultItemsSize ? resultItems.get(i).getAsJsonObject() : null;
                bl = work.handleBulkResult(context, resultItem);
            }
            catch (RuntimeException e) {
                if (resultHandlingExceptions == null) {
                    resultHandlingExceptions = new ArrayList<RuntimeException>();
                }
                resultHandlingExceptions.add(e);
                bl = false;
            }
            if (bl) {
                successfulItems.put(work, resultItem);
            } else {
                erroneousItems.add(work);
            }
            ++i;
        }
        if (!erroneousItems.isEmpty()) {
            GsonProvider gsonProvider = context.getGsonProvider();
            BulkRequestFailedException exception = LOG.elasticsearchBulkRequestFailed(ElasticsearchClientUtils.formatRequest(gsonProvider, this.request), ElasticsearchClientUtils.formatResponse(gsonProvider, response), successfulItems, erroneousItems);
            if (resultHandlingExceptions != null) {
                for (Exception exception2 : resultHandlingExceptions) {
                    exception.addSuppressed(exception2);
                }
            }
            throw exception;
        }
    }

    public static class Builder
    implements BulkWorkBuilder {
        private final List<BulkableElasticsearchWork<?>> bulkableWorks;
        private boolean refreshInBulkAPICall;

        public Builder(List<BulkableElasticsearchWork<?>> bulkableWorks) {
            this.bulkableWorks = bulkableWorks;
        }

        @Override
        public Builder refresh(boolean refresh) {
            this.refreshInBulkAPICall = refresh;
            return this;
        }

        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.post().pathComponent(Paths._BULK).param("refresh", this.refreshInBulkAPICall);
            for (BulkableElasticsearchWork<?> work : this.bulkableWorks) {
                builder.body(work.getBulkableActionMetadata());
                JsonObject actionBody = work.getBulkableActionBody();
                if (actionBody == null) continue;
                builder.body(actionBody);
            }
            return builder.build();
        }

        @Override
        public BulkWork build() {
            return new BulkWork(this);
        }
    }

    private static class NoIndexDirtyBulkExecutionContext
    extends ForwardingElasticsearchWorkExecutionContext {
        public NoIndexDirtyBulkExecutionContext(ElasticsearchWorkExecutionContext delegate) {
            super(delegate);
        }

        @Override
        public void setIndexDirty(URLEncodedString indexName) {
        }
    }
}

