/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.client.impl;

import org.apache.http.HttpHost;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

final class ServerUris {
    private static final Log log = (Log)LoggerFactory.make(Log.class);
    private final HttpHost[] hosts;
    private final boolean anyHostRequiresSSL;

    private ServerUris(HttpHost[] hosts, boolean anyHostRequiresSSL) {
        this.hosts = hosts;
        this.anyHostRequiresSSL = anyHostRequiresSSL;
    }

    static ServerUris fromString(String serverUrisString) {
        String[] serverUris = serverUrisString.trim().split("\\s");
        HttpHost[] hosts = new HttpHost[serverUris.length];
        boolean anyHostRequiresSSL = false;
        for (int i = 0; i < serverUris.length; ++i) {
            HttpHost host;
            hosts[i] = host = HttpHost.create((String)serverUris[i]);
            String scheme = host.getSchemeName();
            if (!"https".equals(scheme)) continue;
            anyHostRequiresSSL = true;
        }
        return new ServerUris(hosts, anyHostRequiresSSL);
    }

    HttpHost[] asHostsArray() {
        return this.hosts;
    }

    boolean isAnyRequiringSSL() {
        return this.anyHostRequiresSSL;
    }

    void warnPasswordsOverHttp() {
        for (HttpHost host : this.hosts) {
            if (!"http".equals(host.getSchemeName())) continue;
            log.usingPasswordOverHttp(host.toURI());
        }
    }
}

