/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.schema.impl;

import org.apache.lucene.document.Field;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalyzerReference;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.schema.impl.Elasticsearch50SchemaTranslator;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchMappingBuilder;
import org.hibernate.search.elasticsearch.schema.impl.model.DataType;
import org.hibernate.search.elasticsearch.schema.impl.model.PropertyMapping;
import org.hibernate.search.elasticsearch.settings.impl.ElasticsearchIndexSettingsBuilder;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class Elasticsearch52SchemaTranslator
extends Elasticsearch50SchemaTranslator {
    private static final Log log = (Log)LoggerFactory.make(Log.class);

    @Override
    protected void addAnalyzerOptions(PropertyMapping propertyMapping, ElasticsearchMappingBuilder mappingBuilder, ElasticsearchIndexSettingsBuilder settingsBuilder, String propertyPath, Field.Index index, AnalyzerReference analyzerReference) {
        super.addAnalyzerOptions(propertyMapping, mappingBuilder, settingsBuilder, propertyPath, index, analyzerReference);
        DataType type = propertyMapping.getType();
        if (DataType.KEYWORD.equals((Object)type) && analyzerReference != null) {
            if (!analyzerReference.is(ElasticsearchAnalyzerReference.class)) {
                log.analyzerIsNotElasticsearch(mappingBuilder.getTypeIdentifier(), propertyPath, analyzerReference);
            } else {
                ElasticsearchAnalyzerReference elasticsearchReference = (ElasticsearchAnalyzerReference)analyzerReference.unwrap(ElasticsearchAnalyzerReference.class);
                if (elasticsearchReference.isNormalizer(propertyPath)) {
                    String normalizerName = settingsBuilder.register(elasticsearchReference, propertyPath);
                    propertyMapping.setNormalizer(normalizerName);
                }
            }
        }
    }

    @Override
    protected DataType getStringType(String propertyPath, Field.Index index, AnalyzerReference analyzerReference) {
        ElasticsearchAnalyzerReference elasticsearchReference;
        if (!index.isAnalyzed()) {
            return DataType.KEYWORD;
        }
        if (analyzerReference != null && analyzerReference.is(ElasticsearchAnalyzerReference.class) && (elasticsearchReference = (ElasticsearchAnalyzerReference)analyzerReference.unwrap(ElasticsearchAnalyzerReference.class)).isNormalizer(propertyPath)) {
            return DataType.KEYWORD;
        }
        return DataType.TEXT;
    }
}

