/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.query.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.search.TopDocs;
import org.hibernate.search.elasticsearch.impl.ElasticsearchQueryOptions;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.query.impl.IndexSearcher;
import org.hibernate.search.elasticsearch.util.impl.Window;
import org.hibernate.search.elasticsearch.work.impl.SearchResult;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class ElasticsearchScrollAPIDocumentExtractor
implements DocumentExtractor {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final IndexSearcher searcher;
    private final int firstIndex;
    private final Integer queryIndexLimit;
    private String scrollId;
    private Integer totalResultCount;
    private final Window<EntityInfo> results;

    public ElasticsearchScrollAPIDocumentExtractor(IndexSearcher searcher, int firstResult, Integer maxResults) {
        this.searcher = searcher;
        this.firstIndex = firstResult;
        this.queryIndexLimit = maxResults == null ? null : Integer.valueOf(firstResult + maxResults);
        ElasticsearchQueryOptions queryOptions = searcher.getQueryOptions();
        this.results = new Window(0, queryOptions.getScrollBacktrackingWindowSize() + queryOptions.getScrollFetchSize());
    }

    public EntityInfo extract(int index) throws IOException {
        int maxIndex;
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index must be >= 0");
        }
        if (index < this.results.start()) {
            throw LOG.backtrackingWindowOverflow(this.searcher.getQueryOptions().getScrollBacktrackingWindowSize(), this.results.start(), index);
        }
        if (this.totalResultCount == null) {
            this.initResults();
        }
        if ((maxIndex = this.getMaxIndex()) < index) {
            throw new IndexOutOfBoundsException("Index must be <= " + maxIndex);
        }
        boolean fetchMayReturnResults = true;
        while (this.results.start() + this.results.size() <= index && fetchMayReturnResults) {
            fetchMayReturnResults = this.fetchNextResults();
        }
        return this.results.get(index);
    }

    public int getFirstIndex() {
        return this.firstIndex;
    }

    public int getMaxIndex() {
        if (this.totalResultCount == null) {
            this.initResults();
        }
        if (this.queryIndexLimit == null) {
            return this.totalResultCount - 1;
        }
        return Math.min(this.totalResultCount, this.queryIndexLimit) - 1;
    }

    public void close() {
        if (this.scrollId != null) {
            this.searcher.clearScroll(this.scrollId);
            this.scrollId = null;
            this.totalResultCount = null;
            this.results.clear();
        }
    }

    public TopDocs getTopDocs() {
        throw LOG.documentExtractorTopDocsUnsupported();
    }

    private void initResults() {
        SearchResult searchResult = this.searcher.searchWithScrollEnabled();
        this.totalResultCount = searchResult.getTotalHitCount();
        this.extractWindow(searchResult);
    }

    private boolean fetchNextResults() {
        if (this.totalResultCount <= this.results.start() + this.results.size()) {
            return false;
        }
        SearchResult searchResult = this.searcher.scroll(this.scrollId);
        return this.extractWindow(searchResult);
    }

    private boolean extractWindow(SearchResult searchResult) {
        boolean fetchedAtLeastOne = false;
        this.scrollId = searchResult.getScrollId();
        JsonArray hits = searchResult.getHits();
        for (JsonElement hit : hits) {
            EntityInfo converted = this.searcher.convertQueryHit(searchResult, hit.getAsJsonObject());
            if (converted == null) continue;
            this.results.add(converted);
            fetchedAtLeastOne = true;
        }
        return fetchedAtLeastOne;
    }
}

