/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.analyzer.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.analyzer.spi.AnalyzerStrategy;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.NormalizerDef;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.elasticsearch.analyzer.definition.ElasticsearchAnalysisDefinitionProvider;
import org.hibernate.search.elasticsearch.analyzer.definition.impl.ChainingElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.elasticsearch.analyzer.definition.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.elasticsearch.analyzer.definition.impl.ElasticsearchAnalysisDefinitionRegistryBuilderImpl;
import org.hibernate.search.elasticsearch.analyzer.definition.impl.NamespaceMergingElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.elasticsearch.analyzer.definition.impl.SimpleElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalyzerReference;
import org.hibernate.search.elasticsearch.analyzer.impl.LuceneClassElasticsearchAnalyzerReference;
import org.hibernate.search.elasticsearch.analyzer.impl.NamedElasticsearch2NormalizerReference;
import org.hibernate.search.elasticsearch.analyzer.impl.NamedElasticsearchAnalyzerReference;
import org.hibernate.search.elasticsearch.analyzer.impl.ScopedElasticsearchAnalyzerReference;
import org.hibernate.search.elasticsearch.analyzer.impl.TranslatingElasticsearchAnalysisDefinitionRegistryPopulator;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.settings.impl.translation.ElasticsearchAnalyzerDefinitionTranslator;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.ServiceReference;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class Elasticsearch2AnalyzerStrategy
implements AnalyzerStrategy {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ServiceManager serviceManager;
    private final SimpleElasticsearchAnalysisDefinitionRegistry defaultDefinitionRegistry;

    public Elasticsearch2AnalyzerStrategy(ServiceManager serviceManager, SearchConfiguration cfg) {
        this.serviceManager = serviceManager;
        this.defaultDefinitionRegistry = this.createDefaultDefinitionRegistry(cfg);
    }

    private SimpleElasticsearchAnalysisDefinitionRegistry createDefaultDefinitionRegistry(SearchConfiguration cfg) {
        ElasticsearchAnalysisDefinitionRegistryBuilderImpl builder = new ElasticsearchAnalysisDefinitionRegistryBuilderImpl();
        String providerClassName = cfg.getProperty("hibernate.search.elasticsearch.analysis_definition_provider");
        if (providerClassName != null) {
            ElasticsearchAnalysisDefinitionProvider provider;
            try {
                Class providerClazz = ClassLoaderHelper.classForName((String)providerClassName, (ServiceManager)this.serviceManager);
                provider = (ElasticsearchAnalysisDefinitionProvider)ReflectionHelper.createInstance((Class)providerClazz, (boolean)true);
            }
            catch (RuntimeException e) {
                throw LOG.invalidElasticsearchAnalyzerDefinitionProvider(providerClassName, e);
            }
            try {
                provider.register(builder);
            }
            catch (SearchException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw LOG.invalidLuceneAnalyzerDefinitionProvider(providerClassName, e);
            }
        }
        SimpleElasticsearchAnalysisDefinitionRegistry registry = new SimpleElasticsearchAnalysisDefinitionRegistry();
        builder.build(this.wrapForAdditions(registry));
        return registry;
    }

    protected ElasticsearchAnalysisDefinitionRegistry wrapForAdditions(ElasticsearchAnalysisDefinitionRegistry registry) {
        return new NamespaceMergingElasticsearchAnalysisDefinitionRegistry(registry);
    }

    public ElasticsearchAnalyzerReference createDefaultAnalyzerReference() {
        return new NamedElasticsearchAnalyzerReference("default");
    }

    public ElasticsearchAnalyzerReference createPassThroughAnalyzerReference() {
        return new NamedElasticsearchAnalyzerReference("keyword");
    }

    public Map<String, AnalyzerReference> createProvidedAnalyzerReferences() {
        HashMap<String, AnalyzerReference> references = new HashMap<String, AnalyzerReference>();
        for (String defaultAnalyzerName : this.defaultDefinitionRegistry.getAnalyzerDefinitions().keySet()) {
            NamedElasticsearchAnalyzerReference reference = this.createNamedAnalyzerReference(defaultAnalyzerName);
            references.put(defaultAnalyzerName, (AnalyzerReference)reference);
        }
        return references;
    }

    public NamedElasticsearchAnalyzerReference createNamedAnalyzerReference(String name) {
        return new NamedElasticsearchAnalyzerReference(name);
    }

    public ElasticsearchAnalyzerReference createLuceneClassAnalyzerReference(Class<?> analyzerClass) {
        return new LuceneClassElasticsearchAnalyzerReference(analyzerClass);
    }

    public Map<String, AnalyzerReference> createProvidedNormalizerReferences() {
        HashMap<String, AnalyzerReference> references = new HashMap<String, AnalyzerReference>();
        for (String name : this.defaultDefinitionRegistry.getNormalizerDefinitions().keySet()) {
            ElasticsearchAnalyzerReference reference = this.createNamedNormalizerReference(name);
            references.put(name, (AnalyzerReference)reference);
        }
        return references;
    }

    public ElasticsearchAnalyzerReference createNamedNormalizerReference(String name) {
        return new NamedElasticsearch2NormalizerReference(name);
    }

    public ElasticsearchAnalyzerReference createLuceneClassNormalizerReference(Class<?> analyzerClass) {
        throw LOG.cannotUseNormalizerImpl(analyzerClass);
    }

    public void initializeReferences(Collection<AnalyzerReference> analyzerReferences, Map<String, AnalyzerDef> mappingAnalyzerDefinitions, Collection<AnalyzerReference> normalizerReferences, Map<String, NormalizerDef> mappingNormalizerDefinitions) {
        try (ServiceReference translatorReference = this.serviceManager.requestReference(ElasticsearchAnalyzerDefinitionTranslator.class);){
            ElasticsearchAnalyzerDefinitionTranslator translator = (ElasticsearchAnalyzerDefinitionTranslator)translatorReference.get();
            ElasticsearchAnalysisDefinitionRegistry definitionRegistry = this.createDefinitionRegistry(analyzerReferences, mappingAnalyzerDefinitions, normalizerReferences, mappingNormalizerDefinitions, this.defaultDefinitionRegistry, translator);
            Stream.concat(analyzerReferences.stream(), normalizerReferences.stream()).map(this::getUninitializedReference).filter(Objects::nonNull).forEach(r -> r.initialize(definitionRegistry, translator));
        }
    }

    private ElasticsearchAnalysisDefinitionRegistry createDefinitionRegistry(Collection<AnalyzerReference> analyzerReferences, Map<String, AnalyzerDef> analyzerDefinitions, Collection<AnalyzerReference> normalizerReferences, Map<String, NormalizerDef> normalizerDefinitions, ElasticsearchAnalysisDefinitionRegistry defaultDefinitionRegistry, ElasticsearchAnalyzerDefinitionTranslator translator) {
        SimpleElasticsearchAnalysisDefinitionRegistry localDefinitionRegistry = new SimpleElasticsearchAnalysisDefinitionRegistry();
        ChainingElasticsearchAnalysisDefinitionRegistry chainingRegistry = new ChainingElasticsearchAnalysisDefinitionRegistry(localDefinitionRegistry, defaultDefinitionRegistry);
        ElasticsearchAnalysisDefinitionRegistry definitionRegistry = this.wrapForAdditions(chainingRegistry);
        Stream.concat(analyzerReferences.stream(), normalizerReferences.stream()).map(this::getInitializedNamedReference).filter(Objects::nonNull).forEach(r -> r.registerDefinitions(null, definitionRegistry));
        TranslatingElasticsearchAnalysisDefinitionRegistryPopulator translatingPopulator = new TranslatingElasticsearchAnalysisDefinitionRegistryPopulator(definitionRegistry, translator);
        analyzerReferences.stream().map(this::getUninitializedNamedReference).filter(Objects::nonNull).map(r -> r.getAnalyzerName(null)).map(analyzerDefinitions::get).filter(Objects::nonNull).forEach(translatingPopulator::registerAnalyzerDef);
        normalizerReferences.stream().map(this::getUninitializedNamedReference).filter(Objects::nonNull).map(r -> r.getAnalyzerName(null)).map(normalizerDefinitions::get).filter(Objects::nonNull).forEach(translatingPopulator::registerNormalizerDef);
        return definitionRegistry;
    }

    private NamedElasticsearchAnalyzerReference getInitializedNamedReference(AnalyzerReference reference) {
        NamedElasticsearchAnalyzerReference esReference;
        if (reference.is(NamedElasticsearchAnalyzerReference.class) && (esReference = (NamedElasticsearchAnalyzerReference)reference.unwrap(NamedElasticsearchAnalyzerReference.class)).isInitialized()) {
            return esReference;
        }
        return null;
    }

    private NamedElasticsearchAnalyzerReference getUninitializedNamedReference(AnalyzerReference reference) {
        ElasticsearchAnalyzerReference esReference = this.getUninitializedReference(reference);
        if (esReference != null && esReference.is(NamedElasticsearchAnalyzerReference.class)) {
            return (NamedElasticsearchAnalyzerReference)esReference.unwrap(NamedElasticsearchAnalyzerReference.class);
        }
        return null;
    }

    private ElasticsearchAnalyzerReference getUninitializedReference(AnalyzerReference reference) {
        ElasticsearchAnalyzerReference esReference;
        if (reference.is(ElasticsearchAnalyzerReference.class) && !(esReference = (ElasticsearchAnalyzerReference)reference.unwrap(ElasticsearchAnalyzerReference.class)).isInitialized()) {
            return esReference;
        }
        return null;
    }

    public ScopedElasticsearchAnalyzerReference.Builder buildScopedAnalyzerReference(AnalyzerReference initialGlobalAnalyzerReference) {
        return new ScopedElasticsearchAnalyzerReference.Builder((ElasticsearchAnalyzerReference)initialGlobalAnalyzerReference.unwrap(ElasticsearchAnalyzerReference.class), Collections.emptyMap());
    }
}

