/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.settings.impl;

import org.hibernate.search.elasticsearch.analyzer.definition.impl.SimpleElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalyzerReference;
import org.hibernate.search.elasticsearch.settings.impl.model.IndexSettings;

public class ElasticsearchIndexSettingsBuilder {
    private final SimpleElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry = new SimpleElasticsearchAnalysisDefinitionRegistry();

    public String register(ElasticsearchAnalyzerReference analyzerReference, String fieldName) {
        analyzerReference.registerDefinitions(fieldName, this.analysisDefinitionRegistry);
        return analyzerReference.getAnalyzerName(fieldName);
    }

    public IndexSettings build() {
        IndexSettings settings = new IndexSettings();
        if (!this.analysisDefinitionRegistry.getAnalyzerDefinitions().isEmpty()) {
            this.getAnalysis(settings).setAnalyzers(this.analysisDefinitionRegistry.getAnalyzerDefinitions());
        }
        if (!this.analysisDefinitionRegistry.getNormalizerDefinitions().isEmpty()) {
            this.getAnalysis(settings).setNormalizers(this.analysisDefinitionRegistry.getNormalizerDefinitions());
        }
        if (!this.analysisDefinitionRegistry.getTokenizerDefinitions().isEmpty()) {
            this.getAnalysis(settings).setTokenizers(this.analysisDefinitionRegistry.getTokenizerDefinitions());
        }
        if (!this.analysisDefinitionRegistry.getTokenFilterDefinitions().isEmpty()) {
            this.getAnalysis(settings).setTokenFilters(this.analysisDefinitionRegistry.getTokenFilterDefinitions());
        }
        if (!this.analysisDefinitionRegistry.getCharFilterDefinitions().isEmpty()) {
            this.getAnalysis(settings).setCharFilters(this.analysisDefinitionRegistry.getCharFilterDefinitions());
        }
        return settings;
    }

    private IndexSettings.Analysis getAnalysis(IndexSettings settings) {
        IndexSettings.Analysis analysis = settings.getAnalysis();
        if (analysis == null) {
            analysis = new IndexSettings.Analysis();
            settings.setAnalysis(analysis);
        }
        return analysis;
    }
}

