/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.settings.impl.translation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.elasticsearch.settings.impl.translation.ParametersTransformer;

class CjkBigramIgnoredScriptsParametersTransformer
implements ParametersTransformer {
    private static final Set<String> SCRIPTS;

    CjkBigramIgnoredScriptsParametersTransformer() {
    }

    @Override
    public Map<String, JsonElement> transform(Map<String, String> luceneParameters) {
        JsonBuilder.Array ignoredScriptsBuilder = JsonBuilder.array();
        for (String script : SCRIPTS) {
            String value = luceneParameters.remove(script);
            if (value == null || Boolean.parseBoolean(value)) continue;
            ignoredScriptsBuilder.add((JsonElement)new JsonPrimitive(script));
        }
        JsonArray ignoredScripts = ignoredScriptsBuilder.build();
        if (ignoredScripts.size() > 0) {
            LinkedHashMap<String, JsonElement> result = new LinkedHashMap<String, JsonElement>();
            result.put("ignored_scripts", (JsonElement)ignoredScripts);
            return result;
        }
        return Collections.emptyMap();
    }

    static {
        LinkedHashSet<String> scripts = new LinkedHashSet<String>();
        scripts.add("han");
        scripts.add("hiragana");
        scripts.add("katakana");
        scripts.add("hangul");
        SCRIPTS = Collections.unmodifiableSet(scripts);
    }
}

