/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.spi;

import org.hibernate.search.analyzer.spi.AnalyzerStrategy;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.elasticsearch.impl.ElasticsearchService;
import org.hibernate.search.engine.nulls.impl.MissingValueStrategy;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.ServiceReference;
import org.hibernate.search.indexes.spi.IndexManagerType;

public final class ElasticsearchIndexManagerType
implements IndexManagerType {
    public static final ElasticsearchIndexManagerType INSTANCE = new ElasticsearchIndexManagerType();

    private ElasticsearchIndexManagerType() {
    }

    public AnalyzerStrategy createAnalyzerStrategy(ServiceManager serviceManager, SearchConfiguration cfg) {
        try (ServiceReference esService = serviceManager.requestReference(ElasticsearchService.class);){
            AnalyzerStrategy analyzerStrategy = ((ElasticsearchService)esService.get()).getAnalyzerStrategyFactory().create(cfg);
            return analyzerStrategy;
        }
    }

    public MissingValueStrategy createMissingValueStrategy(ServiceManager serviceManager, SearchConfiguration cfg) {
        try (ServiceReference esService = serviceManager.requestReference(ElasticsearchService.class);){
            MissingValueStrategy missingValueStrategy = ((ElasticsearchService)esService.get()).getMissingValueStrategy();
            return missingValueStrategy;
        }
    }
}

