/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.work.impl;

import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchResponse;
import org.hibernate.search.elasticsearch.client.impl.Paths;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.SimpleElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.builder.DeleteByQueryWorkBuilder;
import org.hibernate.search.elasticsearch.work.impl.builder.RefreshWorkBuilder;
import org.hibernate.search.elasticsearch.work.impl.factory.ElasticsearchWorkFactory;

public class ES5DeleteByQueryWork
extends SimpleElasticsearchWork<Void> {
    private final ElasticsearchWork<?> refreshWork;

    protected ES5DeleteByQueryWork(Builder builder) {
        super(builder);
        this.refreshWork = builder.buildRefreshWork();
    }

    @Override
    protected CompletableFuture<?> beforeExecute(ElasticsearchWorkExecutionContext executionContext, ElasticsearchRequest request) {
        return this.refreshWork.execute(executionContext);
    }

    @Override
    protected Void generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        return null;
    }

    public static class Builder
    extends SimpleElasticsearchWork.Builder<Builder>
    implements DeleteByQueryWorkBuilder {
        private final URLEncodedString indexName;
        private final JsonObject payload;
        private final Set<URLEncodedString> typeNames = new HashSet<URLEncodedString>();
        private final RefreshWorkBuilder refreshWorkBuilder;

        public Builder(URLEncodedString indexName, JsonObject payload, ElasticsearchWorkFactory workFactory) {
            super(indexName, DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.indexName = indexName;
            this.payload = payload;
            this.refreshWorkBuilder = workFactory.refresh().index(indexName);
        }

        @Override
        public Builder type(URLEncodedString typeName) {
            this.typeNames.add(typeName);
            return this;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.post().pathComponent(this.indexName).param("conflicts", "proceed");
            if (!this.typeNames.isEmpty()) {
                builder.multiValuedPathComponent(this.typeNames);
            }
            builder.pathComponent(Paths._DELETE_BY_QUERY).body(this.payload);
            return builder.build();
        }

        protected ElasticsearchWork<?> buildRefreshWork() {
            return this.refreshWorkBuilder.build();
        }

        @Override
        public ES5DeleteByQueryWork build() {
            return new ES5DeleteByQueryWork(this);
        }
    }
}

