/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.configuration.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.hibernate.search.SearchException;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ConfigurationParseHelper {
    private static final Log log = LoggerFactory.make();

    private ConfigurationParseHelper() {
    }

    public static URL locateConfig(String path) {
        try {
            return new URL(path);
        }
        catch (MalformedURLException e) {
            return ConfigurationParseHelper.findAsResource(path);
        }
    }

    public static URL findAsResource(String path) {
        URL url = null;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            url = contextClassLoader.getResource(path);
        }
        if (url != null) {
            return url;
        }
        url = ConfigurationParseHelper.class.getClassLoader().getResource(path);
        if (url != null) {
            return url;
        }
        url = ClassLoader.getSystemClassLoader().getResource(path);
        return url;
    }

    public static int parseInt(String value, String errorMsgOnParseFailure) {
        if (value == null) {
            throw new SearchException(errorMsgOnParseFailure);
        }
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException nfe) {
            throw log.getInvalidIntegerValueException(errorMsgOnParseFailure, nfe);
        }
    }

    public static long parseLong(String value, String errorMsgOnParseFailure) {
        if (value == null) {
            throw new SearchException(errorMsgOnParseFailure);
        }
        try {
            return Long.parseLong(value.trim());
        }
        catch (NumberFormatException nfe) {
            throw new SearchException(errorMsgOnParseFailure, nfe);
        }
    }

    public static final int parseInt(String value, int defValue, String errorMsgOnParseFailure) {
        if (StringHelper.isEmpty(value)) {
            return defValue;
        }
        return ConfigurationParseHelper.parseInt(value, errorMsgOnParseFailure);
    }

    public static final long parseLong(String value, long defValue, String errorMsgOnParseFailure) {
        if (StringHelper.isEmpty(value)) {
            return defValue;
        }
        return ConfigurationParseHelper.parseLong(value, errorMsgOnParseFailure);
    }

    public static final int getIntValue(Properties cfg, String key, int defValue) {
        String propValue = cfg.getProperty(key);
        return ConfigurationParseHelper.parseInt(propValue, defValue, "Unable to parse " + key + ": " + propValue);
    }

    public static long getLongValue(Properties cfg, String key, long defaultValue) {
        String propValue = cfg.getProperty(key);
        return ConfigurationParseHelper.parseLong(propValue, defaultValue, "Unable to parse " + key + ": " + propValue);
    }

    public static final boolean parseBoolean(String value, String errorMsgOnParseFailure) {
        if (value == null) {
            throw new SearchException(errorMsgOnParseFailure);
        }
        if ("false".equalsIgnoreCase(value.trim())) {
            return false;
        }
        if ("true".equalsIgnoreCase(value.trim())) {
            return true;
        }
        throw new SearchException(errorMsgOnParseFailure);
    }

    public static final boolean getBooleanValue(Properties cfg, String key, boolean defaultValue) {
        String propValue = cfg.getProperty(key);
        if (propValue == null) {
            return defaultValue;
        }
        return ConfigurationParseHelper.parseBoolean(propValue, "Property '" + key + "' needs to be either literal 'true' or 'false'");
    }

    public static final String getString(Properties cfg, String key, String defaultValue) {
        if (cfg == null) {
            return defaultValue;
        }
        String propValue = cfg.getProperty(key);
        return propValue == null ? defaultValue : propValue;
    }
}

