/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.lang.invoke.MethodHandles;
import java.util.Properties;
import org.hibernate.search.backend.impl.lucene.AbstractWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.ExclusiveIndexWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.SharedIndexWorkspaceImpl;
import org.hibernate.search.indexes.impl.PropertiesParseHelper;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

final class WorkspaceFactory {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());

    private WorkspaceFactory() {
    }

    static AbstractWorkspaceImpl createWorkspace(DirectoryBasedIndexManager indexManager, WorkerBuildContext context, Properties cfg) {
        String indexName = indexManager.getIndexName();
        boolean exclusiveIndexUsage = PropertiesParseHelper.isExclusiveIndexUsageEnabled(cfg);
        if (exclusiveIndexUsage) {
            log.debugf("Starting workspace for index " + indexName + " using an exclusive index strategy", new Object[0]);
            return new ExclusiveIndexWorkspaceImpl(indexManager, context, cfg);
        }
        log.debugf("Starting workspace for index " + indexName + " using a shared index strategy", new Object[0]);
        if (context.isHibernateSearch6DeprecationWarningsEnabled()) {
            log.nonExclusiveIndexUseForIndex(indexName);
        }
        return new SharedIndexWorkspaceImpl(indexManager, context, cfg);
    }
}

