/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Properties;
import org.apache.lucene.document.Document;
import org.hibernate.search.filter.FullTextFilterImplementor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.store.IndexShardingStrategy;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class IdHashShardingStrategy
implements IndexShardingStrategy {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private IndexManager[] indexManagers;

    @Override
    public void initialize(Properties properties, IndexManager[] indexManagers) {
        if (indexManagers.length == 1) {
            log.idHashShardingWithSingleShard();
        }
        this.indexManagers = indexManagers;
    }

    @Override
    public IndexManager[] getIndexManagersForAllShards() {
        return this.indexManagers;
    }

    @Override
    public IndexManager getIndexManagerForAddition(Class<?> entity, Serializable id, String idInString, Document document) {
        return this.indexManagers[this.hashKey(idInString)];
    }

    @Override
    public IndexManager[] getIndexManagersForDeletion(Class<?> entity, Serializable id, String idInString) {
        if (idInString == null) {
            return this.indexManagers;
        }
        return new IndexManager[]{this.indexManagers[this.hashKey(idInString)]};
    }

    @Override
    public IndexManager[] getIndexManagersForQuery(FullTextFilterImplementor[] fullTextFilters) {
        return this.getIndexManagersForAllShards();
    }

    private int hashKey(String key) {
        int hash = 0;
        int length = key.length();
        for (int index = 0; index < length; ++index) {
            hash = 31 * hash + key.charAt(index);
        }
        return Math.abs(hash % this.indexManagers.length);
    }
}

