/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial;

import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.spatial.SpatialFieldBridge;
import org.hibernate.search.spatial.impl.SpatialHelper;

public class SpatialFieldBridgeByRange
extends SpatialFieldBridge {
    public SpatialFieldBridgeByRange() {
    }

    public SpatialFieldBridgeByRange(String latitudeField, String longitudeField) {
        this.latitudeField = latitudeField;
        this.longitudeField = longitudeField;
    }

    @Override
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (value != null) {
            Double latitude = this.getLatitude(value);
            Double longitude = this.getLongitude(value);
            if (latitude != null && longitude != null) {
                luceneOptions.addNumericFieldToDocument(SpatialHelper.formatLatitude(name), latitude, document);
                luceneOptions.addNumericFieldToDocument(SpatialHelper.formatLongitude(name), longitude, document);
            }
        }
    }
}

