/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.engine.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.search.bridge.spi.FieldType;
import org.hibernate.search.engine.impl.FilterDef;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.metadata.impl.BridgeDefinedField;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.filter.FullTextFilter;
import org.hibernate.search.filter.FullTextFilterImplementor;
import org.hibernate.search.filter.ShardSensitiveOnlyFilter;
import org.hibernate.search.filter.impl.FullTextFilterImpl;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.metadata.NumericFieldSettingsDescriptor;
import org.hibernate.search.query.engine.impl.TimeoutManagerImpl;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.engine.spi.TimeoutExceptionFactory;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.DistanceSortField;
import org.hibernate.search.spi.CustomTypeMetadata;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.impl.CollectionHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public abstract class AbstractHSQuery
implements HSQuery,
Serializable {
    private static final Log LOG = LoggerFactory.make();
    public static final String HSEARCH_PROJECTION_FIELD_PREFIX = "__HSearch_";
    private static final FullTextFilterImplementor[] EMPTY_FULL_TEXT_FILTER_IMPLEMENTOR_ARRAY = new FullTextFilterImplementor[0];
    protected transient ExtendedSearchIntegrator extendedIntegrator;
    protected transient TimeoutExceptionFactory timeoutExceptionFactory;
    protected transient TimeoutManagerImpl timeoutManager;
    protected List<Class<?>> targetedEntities;
    protected Set<Class<?>> indexedTargetedEntities;
    private List<CustomTypeMetadata> customTypeMetadata;
    protected Sort sort;
    protected String tenantId;
    protected String[] projectedFields;
    protected boolean hasThisProjection;
    protected int firstResult;
    protected Integer maxResults;
    protected Coordinates spatialSearchCenter = null;
    protected String spatialFieldName = null;
    protected Filter userFilter;
    protected final Map<String, FullTextFilterImpl> filterDefinitions = CollectionHelper.newHashMap();

    public AbstractHSQuery(ExtendedSearchIntegrator extendedIntegrator) {
        this.extendedIntegrator = extendedIntegrator;
        this.timeoutExceptionFactory = extendedIntegrator.getDefaultTimeoutExceptionFactory();
    }

    @Override
    public void afterDeserialise(SearchIntegrator extendedIntegrator) {
        this.extendedIntegrator = extendedIntegrator.unwrap(ExtendedSearchIntegrator.class);
    }

    @Override
    public HSQuery setSpatialParameters(Coordinates center, String fieldName) {
        this.spatialSearchCenter = center;
        this.spatialFieldName = fieldName;
        return this;
    }

    @Override
    public HSQuery tenantIdentifier(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public final HSQuery targetedEntities(List<Class<?>> classes) {
        this.setTargetedEntities(classes == null ? new ArrayList(0) : new ArrayList(classes));
        this.customTypeMetadata = Collections.emptyList();
        return this;
    }

    private void setTargetedEntities(List<Class<?>> classes) {
        this.clearCachedResults();
        this.targetedEntities = classes;
        Class[] classesAsArray = this.targetedEntities.toArray(new Class[this.targetedEntities.size()]);
        this.indexedTargetedEntities = this.extendedIntegrator.getIndexedTypesPolymorphic(classesAsArray);
        if (this.targetedEntities.size() > 0 && this.indexedTargetedEntities.size() == 0) {
            throw LOG.targetedEntityTypesNotIndexed(StringHelper.join(this.targetedEntities, ","));
        }
    }

    @Override
    public final HSQuery targetedTypes(List<CustomTypeMetadata> types) {
        if (types == null) {
            return this.targetedEntities(null);
        }
        List<Class<?>> entityTypes = types.stream().map(CustomTypeMetadata::getEntityType).collect(Collectors.toList());
        this.setTargetedEntities(entityTypes);
        this.customTypeMetadata = new ArrayList<CustomTypeMetadata>(types);
        return this;
    }

    protected final Optional<CustomTypeMetadata> getCustomTypeMetadata(Class<?> clazz) {
        return this.customTypeMetadata.stream().filter((? super T metadata) -> metadata.getEntityType().isAssignableFrom(clazz)).findFirst();
    }

    @Override
    public HSQuery sort(Sort sort) {
        this.clearCachedResults();
        this.sort = sort;
        return this;
    }

    @Override
    public HSQuery filter(Filter filter) {
        this.clearCachedResults();
        this.userFilter = filter;
        return this;
    }

    @Override
    public HSQuery timeoutExceptionFactory(TimeoutExceptionFactory exceptionFactory) {
        this.timeoutExceptionFactory = exceptionFactory;
        return this;
    }

    @Override
    public HSQuery projection(String ... fields) {
        if (fields == null || fields.length == 0) {
            this.projectedFields = null;
        } else {
            this.projectedFields = fields;
            boolean hasThis = false;
            Set<String> supportedProjectionConstants = this.getSupportedProjectionConstants();
            for (String field : fields) {
                if ("__HSearch_This".equals(field)) {
                    hasThis = true;
                }
                if (field == null || !field.startsWith(HSEARCH_PROJECTION_FIELD_PREFIX) || supportedProjectionConstants.contains(field)) continue;
                throw LOG.unexpectedProjectionConstant(field);
            }
            this.hasThisProjection = hasThis;
        }
        this.clearCachedResults();
        return this;
    }

    @Override
    public HSQuery firstResult(int firstResult) {
        this.clearCachedResults();
        if (firstResult < 0) {
            throw new IllegalArgumentException("'first' pagination parameter less than 0");
        }
        this.firstResult = firstResult;
        return this;
    }

    @Override
    public HSQuery maxResults(int maxResults) {
        this.clearCachedResults();
        if (maxResults < 0) {
            throw new IllegalArgumentException("'max' pagination parameter less than 0");
        }
        this.maxResults = maxResults;
        return this;
    }

    @Override
    public FullTextFilter enableFullTextFilter(String name) {
        this.clearCachedResults();
        FullTextFilterImpl filterDefinition = this.filterDefinitions.get(name);
        if (filterDefinition != null) {
            return filterDefinition;
        }
        filterDefinition = new FullTextFilterImpl();
        filterDefinition.setName(name);
        FilterDef filterDef = this.extendedIntegrator.getFilterDefinition(name);
        if (filterDef == null) {
            throw LOG.unknownFullTextFilter(name);
        }
        this.filterDefinitions.put(name, filterDefinition);
        return filterDefinition;
    }

    @Override
    public void disableFullTextFilter(String name) {
        this.clearCachedResults();
        this.filterDefinitions.remove(name);
    }

    protected Object createFilterInstance(FullTextFilterImpl fullTextFilter, FilterDef def) {
        Object instance = ClassLoaderHelper.instanceFromClass(Object.class, def.getImpl(), "@FullTextFilterDef");
        for (Map.Entry<String, Object> entry : fullTextFilter.getParameters().entrySet()) {
            def.invoke(entry.getKey(), instance, entry.getValue());
        }
        return instance;
    }

    protected boolean isPreQueryFilterOnly(FilterDef def) {
        return def.getImpl().equals(ShardSensitiveOnlyFilter.class);
    }

    @Override
    public List<Class<?>> getTargetedEntities() {
        return this.targetedEntities;
    }

    @Override
    public Set<Class<?>> getIndexedTargetedEntities() {
        return this.indexedTargetedEntities;
    }

    @Override
    public String[] getProjectedFields() {
        return this.projectedFields;
    }

    @Override
    public boolean hasThisProjection() {
        return this.hasThisProjection;
    }

    @Override
    public TimeoutManagerImpl getTimeoutManager() {
        if (this.timeoutManager == null) {
            this.timeoutManager = this.buildTimeoutManager();
        }
        return this.timeoutManager;
    }

    @Override
    public ExtendedSearchIntegrator getExtendedSearchIntegrator() {
        return this.extendedIntegrator;
    }

    protected abstract Set<String> getSupportedProjectionConstants();

    protected void validateSortFields(ExtendedSearchIntegrator extendedIntegrator, Iterable<Class<?>> targetedEntities) {
        SortField[] sortFields;
        for (SortField sortField : sortFields = this.sort.getSort()) {
            this.validateSortField(extendedIntegrator, targetedEntities, sortField);
        }
    }

    private void validateSortField(ExtendedSearchIntegrator extendedIntegrator, Iterable<Class<?>> targetedEntities, SortField sortField) {
        if (sortField instanceof DistanceSortField) {
            this.validateDistanceSortField(extendedIntegrator, targetedEntities, sortField);
        } else if (sortField.getType() != SortField.Type.CUSTOM) {
            if (sortField.getField() == null) {
                this.validateNullSortField(sortField);
            } else {
                this.validateCommonSortField(extendedIntegrator, targetedEntities, sortField);
            }
        }
    }

    private void validateNullSortField(SortField sortField) {
        if (sortField.getType() != SortField.Type.DOC && sortField.getType() != SortField.Type.SCORE) {
            throw LOG.sortRequiresIndexedField(sortField.getClass(), sortField.getField());
        }
    }

    private void validateDistanceSortField(ExtendedSearchIntegrator extendedIntegrator, Iterable<Class<?>> targetedEntities, SortField sortField) {
        DocumentFieldMetadata documentFieldMetadata = this.findFieldMetadata(extendedIntegrator, targetedEntities, sortField.getField());
        if (documentFieldMetadata == null) {
            throw LOG.sortRequiresIndexedField(sortField.getClass(), sortField.getField());
        }
        if (!documentFieldMetadata.isSpatial()) {
            throw LOG.distanceSortRequiresSpatialField(sortField.getField());
        }
    }

    private void validateCommonSortField(ExtendedSearchIntegrator extendedIntegrator, Iterable<Class<?>> targetedEntities, SortField sortField) {
        BridgeDefinedField bridgeDefinedField = this.findBridgeDefinedField(extendedIntegrator, targetedEntities, sortField.getField());
        if (bridgeDefinedField != null) {
            this.validateSortField(sortField, bridgeDefinedField);
        } else {
            DocumentFieldMetadata metadata = this.findFieldMetadata(extendedIntegrator, targetedEntities, sortField.getField());
            if (metadata != null) {
                this.validateSortField(sortField, metadata);
            }
        }
    }

    private void validateSortField(SortField sortField, BridgeDefinedField bridgeDefinedField) {
        switch (sortField.getType()) {
            case INT: {
                this.assertType(sortField, bridgeDefinedField.getType(), FieldType.INTEGER);
                break;
            }
            case LONG: {
                this.assertType(sortField, bridgeDefinedField.getType(), FieldType.LONG);
                break;
            }
            case DOUBLE: {
                this.assertType(sortField, bridgeDefinedField.getType(), FieldType.DOUBLE);
                break;
            }
            case FLOAT: {
                this.assertType(sortField, bridgeDefinedField.getType(), FieldType.FLOAT);
                break;
            }
            case STRING: 
            case STRING_VAL: {
                this.assertType(sortField, bridgeDefinedField.getType(), FieldType.STRING);
                break;
            }
            default: {
                throw LOG.sortTypeDoesNotMatchFieldType(String.valueOf(sortField.getType()), String.valueOf((Object)bridgeDefinedField.getType()), sortField.getField());
            }
        }
    }

    private void assertType(SortField sortField, FieldType actual, FieldType expected) {
        if (actual != expected) {
            throw LOG.sortTypeDoesNotMatchFieldType(String.valueOf(sortField.getType()), String.valueOf((Object)actual), sortField.getField());
        }
    }

    private BridgeDefinedField findBridgeDefinedField(ExtendedSearchIntegrator extendedIntegrator, Iterable<Class<?>> targetedEntities, String fieldPath) {
        if (fieldPath == null) {
            return null;
        }
        for (Class<?> clazz : targetedEntities) {
            EntityIndexBinding indexBinding = extendedIntegrator.getIndexBinding(clazz);
            TypeMetadata typeMetadata = indexBinding.getDocumentBuilder().getTypeMetadata();
            BridgeDefinedField bridgeDefinedField = typeMetadata.getBridgeDefinedFieldMetadataFor(fieldPath);
            if (bridgeDefinedField == null) continue;
            return bridgeDefinedField;
        }
        return null;
    }

    private DocumentFieldMetadata findFieldMetadata(ExtendedSearchIntegrator extendedIntegrator, Iterable<Class<?>> targetedEntities, String fieldPath) {
        if (fieldPath == null) {
            return null;
        }
        for (Class<?> clazz : targetedEntities) {
            EntityIndexBinding indexBinding = extendedIntegrator.getIndexBinding(clazz);
            DocumentFieldMetadata metadata = indexBinding.getDocumentBuilder().getTypeMetadata().getDocumentFieldMetadataFor(fieldPath);
            if (metadata == null) continue;
            return metadata;
        }
        return null;
    }

    private void validateSortField(SortField sortField, DocumentFieldMetadata fieldMetadata) {
        if (fieldMetadata.isNumeric()) {
            NumericFieldSettingsDescriptor.NumericEncodingType numericEncodingType = fieldMetadata.getNumericEncodingType();
            this.validateNumericSortField(sortField, numericEncodingType);
        } else if (sortField.getType() != SortField.Type.STRING && sortField.getType() != SortField.Type.STRING_VAL) {
            throw LOG.sortTypeDoesNotMatchFieldType(String.valueOf(sortField.getType()), "string", sortField.getField());
        }
    }

    private void validateNumericSortField(SortField sortField, NumericFieldSettingsDescriptor.NumericEncodingType indexNumericEncodingType) {
        NumericFieldSettingsDescriptor.NumericEncodingType sortNumericEncodingType;
        switch (sortField.getType()) {
            case INT: 
            case BYTES: {
                sortNumericEncodingType = NumericFieldSettingsDescriptor.NumericEncodingType.INTEGER;
                break;
            }
            case LONG: {
                sortNumericEncodingType = NumericFieldSettingsDescriptor.NumericEncodingType.LONG;
                break;
            }
            case DOUBLE: {
                sortNumericEncodingType = NumericFieldSettingsDescriptor.NumericEncodingType.DOUBLE;
                break;
            }
            case FLOAT: {
                sortNumericEncodingType = NumericFieldSettingsDescriptor.NumericEncodingType.FLOAT;
                break;
            }
            default: {
                throw LOG.sortTypeDoesNotMatchFieldType(String.valueOf(sortField.getType()), String.valueOf((Object)indexNumericEncodingType), sortField.getField());
            }
        }
        if (NumericFieldSettingsDescriptor.NumericEncodingType.UNKNOWN.equals((Object)indexNumericEncodingType)) {
            return;
        }
        this.validateNumericEncodingType(sortField, indexNumericEncodingType, sortNumericEncodingType);
    }

    private void validateNumericEncodingType(SortField sortField, NumericFieldSettingsDescriptor.NumericEncodingType sortEncodingType, NumericFieldSettingsDescriptor.NumericEncodingType indexEncodingType) {
        if (sortEncodingType != indexEncodingType) {
            throw LOG.sortTypeDoesNotMatchFieldType(String.valueOf(sortField.getType()), String.valueOf((Object)indexEncodingType), sortField.getField());
        }
    }

    protected List<IndexManager> getIndexManagers(EntityIndexBinding binding) {
        FullTextFilterImplementor[] fullTextFilters = this.getFullTextFilterImplementors();
        List<IndexManager> indexManagers = Arrays.asList(binding.getSelectionStrategy().getIndexManagersForQuery(fullTextFilters));
        return indexManagers;
    }

    private FullTextFilterImplementor[] getFullTextFilterImplementors() {
        FullTextFilterImplementor[] fullTextFilters = this.filterDefinitions != null && !this.filterDefinitions.isEmpty() ? this.filterDefinitions.values().toArray(new FullTextFilterImplementor[this.filterDefinitions.size()]) : EMPTY_FULL_TEXT_FILTER_IMPLEMENTOR_ARRAY;
        return fullTextFilters;
    }

    protected abstract void extractFacetResults();

    protected abstract void clearCachedResults();

    protected abstract TimeoutManagerImpl buildTimeoutManager();
}

