/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.infinispan.impl;

import java.util.Properties;
import org.apache.lucene.store.Directory;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.infinispan.CacheManagerServiceProvider;
import org.hibernate.search.infinispan.logging.impl.Log;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.impl.DirectoryProviderHelper;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.infinispan.Cache;
import org.infinispan.lucene.InfinispanDirectory;
import org.infinispan.manager.EmbeddedCacheManager;

public class InfinispanDirectoryProvider
implements DirectoryProvider<InfinispanDirectory> {
    private static final Log log = (Log)LoggerFactory.make(Log.class);
    public static final String DEFAULT_LOCKING_CACHENAME = "LuceneIndexesLocking";
    public static final String DEFAULT_INDEXESDATA_CACHENAME = "LuceneIndexesData";
    public static final String DEFAULT_INDEXESMETADATA_CACHENAME = "LuceneIndexesMetadata";
    private BuildContext context;
    private String directoryProviderName;
    private String metadataCacheName;
    private String dataCacheName;
    private String lockingCacheName;
    private int chunkSize;
    private InfinispanDirectory directory;
    private EmbeddedCacheManager cacheManager;

    public void initialize(String directoryProviderName, Properties properties, BuildContext context) {
        this.directoryProviderName = directoryProviderName;
        this.context = context;
        this.metadataCacheName = properties.getProperty("metadata_cachename", DEFAULT_INDEXESMETADATA_CACHENAME);
        this.dataCacheName = properties.getProperty("data_cachename", DEFAULT_INDEXESDATA_CACHENAME);
        this.lockingCacheName = properties.getProperty("locking_cachename", DEFAULT_LOCKING_CACHENAME);
        this.chunkSize = ConfigurationParseHelper.getIntValue((Properties)properties, (String)"chunk_size", (int)16384);
    }

    public void start(DirectoryBasedIndexManager indexManager) {
        log.debug("Starting InfinispanDirectory");
        this.cacheManager = (EmbeddedCacheManager)this.context.requestService(CacheManagerServiceProvider.class);
        this.cacheManager.startCaches(new String[]{this.metadataCacheName, this.dataCacheName, this.lockingCacheName});
        Cache metadataCache = this.cacheManager.getCache(this.metadataCacheName);
        Cache dataCache = this.cacheManager.getCache(this.dataCacheName);
        Cache lockingCache = this.cacheManager.getCache(this.lockingCacheName);
        this.directory = new InfinispanDirectory(metadataCache, dataCache, lockingCache, this.directoryProviderName, this.chunkSize);
        DirectoryProviderHelper.initializeIndexIfNeeded((Directory)this.directory);
        log.debugf("Initialized Infinispan index: '%s'", this.directoryProviderName);
    }

    public void stop() {
        this.directory.close();
        this.context.releaseService(CacheManagerServiceProvider.class);
        log.debug("Stopped InfinispanDirectory");
    }

    public InfinispanDirectory getDirectory() {
        return this.directory;
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }
}

