/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.infinispan.impl;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;

public class InfinispanConfigurationParser {
    private final ParserRegistry configurationParser;
    private final ClassLoader searchConfigClassloader;
    private final ClassLoader userDeploymentClassloader;

    public InfinispanConfigurationParser(ClassLoader searchConfigClassloader) {
        this.searchConfigClassloader = searchConfigClassloader;
        ClassLoader ispnClassLoadr = ParserRegistry.class.getClassLoader();
        this.configurationParser = new ParserRegistry(ispnClassLoadr);
        this.userDeploymentClassloader = Thread.currentThread().getContextClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationBuilderHolder parseFile(String filename) throws IOException {
        FileLookup fileLookup = FileLookupFactory.newInstance();
        InputStream is = fileLookup.lookupFile(filename, this.searchConfigClassloader);
        if (is == null && (is = fileLookup.lookupFile(filename, this.userDeploymentClassloader)) == null) {
            throw new FileNotFoundException(filename);
        }
        try {
            Thread currentThread = Thread.currentThread();
            ClassLoader originalContextClassLoader = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(this.searchConfigClassloader);
                ConfigurationBuilderHolder builderHolder = this.configurationParser.parse(is);
                this.patchInfinispanClassLoader(builderHolder);
                ConfigurationBuilderHolder configurationBuilderHolder = builderHolder;
                currentThread.setContextClassLoader(originalContextClassLoader);
                return configurationBuilderHolder;
            }
            catch (Throwable throwable) {
                currentThread.setContextClassLoader(originalContextClassLoader);
                throw throwable;
            }
        }
        finally {
            Util.close((Closeable)is);
        }
    }

    private void patchInfinispanClassLoader(ConfigurationBuilderHolder configurationBuilderHolder) {
        configurationBuilderHolder.getGlobalConfigurationBuilder().classLoader(this.searchConfigClassloader);
        configurationBuilderHolder.getDefaultConfigurationBuilder().classLoader(this.searchConfigClassloader);
        for (ConfigurationBuilder cfg : configurationBuilderHolder.getNamedConfigurationBuilders().values()) {
            cfg.classLoader(this.searchConfigClassloader);
        }
    }
}

