/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.jms;

import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.hibernate.Session;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.util.impl.ContextHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public abstract class AbstractJMSHibernateSearchController
implements MessageListener {
    private static final Log log = LoggerFactory.make();

    protected abstract Session getSession();

    protected abstract void cleanSessionIfNeeded(Session var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        if (!(message instanceof ObjectMessage)) {
            log.incorrectMessageType(message.getClass());
            return;
        }
        ObjectMessage objectMessage = (ObjectMessage)message;
        Session session = this.getSession();
        SearchFactoryImplementor factory = ContextHelper.getSearchFactory(session);
        try {
            String indexName = objectMessage.getStringProperty("hibernate.search.jms.indexNameProperty");
            IndexManager indexManager = factory.getAllIndexesManager().getIndexManager(indexName);
            if (indexManager == null) {
                log.messageReceivedForUndefinedIndex(indexName);
                return;
            }
            List queue = indexManager.getSerializer().toLuceneWorks((byte[])objectMessage.getObject());
            indexManager.performOperations(queue);
        }
        catch (JMSException e) {
            log.unableToRetrieveObjectFromMessage(message.getClass(), (Exception)((Object)e));
            return;
        }
        catch (ClassCastException e) {
            log.illegalObjectRetrievedFromMessage((Exception)e);
            return;
        }
        finally {
            this.cleanSessionIfNeeded(session);
        }
    }
}

