/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing.impl;

import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.spi.TransactionFactory;
import org.hibernate.search.batchindexing.impl.SessionAwareRunnable;
import org.hibernate.search.batchindexing.impl.StatelessSessionAwareRunnable;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.hibernate.service.jta.platform.spi.JtaPlatform;

public class OptionallyWrapInJTATransaction
implements Runnable {
    private static final Log log = LoggerFactory.make();
    private final SessionFactoryImplementor factory;
    private final SessionAwareRunnable sessionAwareRunnable;
    private final StatelessSessionAwareRunnable statelessSessionAwareRunnable;
    private final ErrorHandler errorHandler;

    public OptionallyWrapInJTATransaction(SessionFactory factory, ErrorHandler errorHandler, SessionAwareRunnable sessionAwareRunnable) {
        this.factory = (SessionFactoryImplementor)factory;
        this.sessionAwareRunnable = sessionAwareRunnable;
        this.statelessSessionAwareRunnable = null;
        this.errorHandler = errorHandler;
    }

    public OptionallyWrapInJTATransaction(SessionFactory factory, ErrorHandler errorHandler, StatelessSessionAwareRunnable statelessSessionAwareRunnable) {
        this.factory = (SessionFactoryImplementor)factory;
        this.sessionAwareRunnable = null;
        this.statelessSessionAwareRunnable = statelessSessionAwareRunnable;
        this.errorHandler = errorHandler;
    }

    @Override
    public void run() {
        block14: {
            try {
                boolean wrapInTransaction = this.wrapInTransaction();
                if (wrapInTransaction) {
                    TransactionManager transactionManager = this.getTransactionManager();
                    try {
                        StatelessSession statelessSession;
                        Session session;
                        if (this.sessionAwareRunnable != null) {
                            session = this.factory.openSession();
                            statelessSession = null;
                        } else {
                            session = null;
                            statelessSession = this.factory.openStatelessSession();
                        }
                        transactionManager.begin();
                        if (this.sessionAwareRunnable != null) {
                            this.sessionAwareRunnable.run(session);
                        } else {
                            this.statelessSessionAwareRunnable.run(statelessSession);
                        }
                        transactionManager.commit();
                        if (this.sessionAwareRunnable != null) {
                            session.close();
                            break block14;
                        }
                        statelessSession.close();
                    }
                    catch (Throwable e) {
                        this.errorHandler.handleException(log.massIndexerUnexpectedErrorMessage(), e);
                        try {
                            transactionManager.rollback();
                            break block14;
                        }
                        catch (SystemException e1) {
                            log.errorRollbackingTransaction(e.getMessage(), (Exception)((Object)e1));
                        }
                    }
                    break block14;
                }
                if (this.sessionAwareRunnable != null) {
                    this.sessionAwareRunnable.run(null);
                } else {
                    this.statelessSessionAwareRunnable.run(null);
                }
            }
            catch (Throwable e) {
                this.errorHandler.handleException(log.massIndexerUnexpectedErrorMessage(), e);
            }
        }
    }

    private TransactionManager getTransactionManager() {
        return ((JtaPlatform)this.factory.getServiceRegistry().getService(JtaPlatform.class)).retrieveTransactionManager();
    }

    boolean wrapInTransaction() {
        TransactionFactory transactionFactory = (TransactionFactory)this.factory.getServiceRegistry().getService(TransactionFactory.class);
        if (!transactionFactory.compatibleWithJtaSynchronization()) {
            log.trace((Object)"TransactionFactory does not require a TransactionManager: don't wrap in a JTA transaction");
            return false;
        }
        TransactionManager transactionManager = this.getTransactionManager();
        if (transactionManager == null) {
            log.trace((Object)"No TransactionManager found, do not start a surrounding JTA transaction");
            return false;
        }
        try {
            if (transactionManager.getStatus() == 6) {
                log.trace((Object)"No Transaction in progress, needs to start a JTA transaction");
                return true;
            }
        }
        catch (SystemException e) {
            log.cannotGuessTransactionStatus((Exception)((Object)e));
            return false;
        }
        log.trace((Object)"Transaction in progress, no needs to start a JTA transaction");
        return false;
    }
}

