/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.hcore.impl;

import java.util.Map;
import java.util.Properties;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.integrator.spi.ServiceContributingIntegrator;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.search.impl.DefaultMassIndexerFactory;
import org.hibernate.search.spi.MassIndexerFactory;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.service.ServiceRegistryBuilder;
import org.hibernate.service.spi.BasicServiceInitiator;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class MassIndexerFactoryIntegrator
implements ServiceContributingIntegrator,
BasicServiceInitiator<MassIndexerFactory> {
    public static final String MASS_INDEXER_FACTORY_CLASSNAME = "hibernate.search.massindexer.factoryclass";

    public Class<MassIndexerFactory> getServiceInitiated() {
        return MassIndexerFactory.class;
    }

    public MassIndexerFactory initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        String factoryClassName = (String)configurationValues.get(MASS_INDEXER_FACTORY_CLASSNAME);
        MassIndexerFactory factory = this.createFactory(factoryClassName);
        factory.initialize(this.properties(configurationValues));
        return factory;
    }

    private Properties properties(Map configurationValues) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)configurationValues);
        return properties;
    }

    private MassIndexerFactory createFactory(String factoryClassName) {
        if (factoryClassName == null) {
            return new DefaultMassIndexerFactory();
        }
        return this.customFactory(factoryClassName);
    }

    private MassIndexerFactory customFactory(String factoryClassName) {
        return (MassIndexerFactory)ClassLoaderHelper.instanceFromName(MassIndexerFactory.class, (String)factoryClassName, (ClassLoader)this.getClass().getClassLoader(), (String)"Mass indexer factory");
    }

    public void integrate(Configuration configuration, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    public void integrate(MetadataImplementor metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    public void prepareServices(ServiceRegistryBuilder serviceRegistryBuilder) {
        serviceRegistryBuilder.addInitiator((BasicServiceInitiator)this);
    }
}

