/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing.impl;

import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import org.hibernate.CacheMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.impl.batch.BatchBackend;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.batchindexing.impl.BatchIndexingWorkspace;
import org.hibernate.search.batchindexing.impl.Executors;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class BatchCoordinator
implements Runnable {
    private static final Log log = LoggerFactory.make();
    private final Class<?>[] rootEntities;
    private final SearchFactoryImplementor searchFactoryImplementor;
    private final SessionFactoryImplementor sessionFactory;
    private final int typesToIndexInParallel;
    private final int objectLoadingThreads;
    private final int collectionLoadingThreads;
    private final CacheMode cacheMode;
    private final int objectLoadingBatchSize;
    private final boolean optimizeAtEnd;
    private final boolean purgeAtStart;
    private final boolean optimizeAfterPurge;
    private final CountDownLatch endAllSignal;
    private final MassIndexerProgressMonitor monitor;
    private final long objectsLimit;
    private final ErrorHandler errorHandler;
    private final int idFetchSize;

    public BatchCoordinator(Set<Class<?>> rootEntities, SearchFactoryImplementor searchFactoryImplementor, SessionFactoryImplementor sessionFactory, int typesToIndexInParallel, int objectLoadingThreads, int collectionLoadingThreads, CacheMode cacheMode, int objectLoadingBatchSize, long objectsLimit, boolean optimizeAtEnd, boolean purgeAtStart, boolean optimizeAfterPurge, MassIndexerProgressMonitor monitor, int idFetchSize) {
        this.idFetchSize = idFetchSize;
        this.rootEntities = rootEntities.toArray(new Class[rootEntities.size()]);
        this.searchFactoryImplementor = searchFactoryImplementor;
        this.sessionFactory = sessionFactory;
        this.typesToIndexInParallel = typesToIndexInParallel;
        this.objectLoadingThreads = objectLoadingThreads;
        this.collectionLoadingThreads = collectionLoadingThreads;
        this.cacheMode = cacheMode;
        this.objectLoadingBatchSize = objectLoadingBatchSize;
        this.optimizeAtEnd = optimizeAtEnd;
        this.purgeAtStart = purgeAtStart;
        this.optimizeAfterPurge = optimizeAfterPurge;
        this.monitor = monitor;
        this.objectsLimit = objectsLimit;
        this.endAllSignal = new CountDownLatch(rootEntities.size());
        this.errorHandler = searchFactoryImplementor.getErrorHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            BatchBackend backend = this.searchFactoryImplementor.makeBatchBackend(this.monitor);
            try {
                this.beforeBatch(backend);
                this.doBatchWork(backend);
                this.afterBatch(backend);
            }
            catch (InterruptedException e) {
                log.interruptedBatchIndexing();
                Thread.currentThread().interrupt();
            }
            finally {
                this.monitor.indexingCompleted();
            }
        }
        catch (RuntimeException re) {
            this.errorHandler.handleException(log.massIndexerUnexpectedErrorMessage(), (Throwable)re);
        }
    }

    private void doBatchWork(BatchBackend backend) throws InterruptedException {
        ThreadPoolExecutor executor = Executors.newFixedThreadPool((int)this.typesToIndexInParallel, (String)"BatchIndexingWorkspace");
        for (Class<?> type : this.rootEntities) {
            executor.execute(new BatchIndexingWorkspace(this.searchFactoryImplementor, this.sessionFactory, type, this.objectLoadingThreads, this.collectionLoadingThreads, this.cacheMode, this.objectLoadingBatchSize, this.endAllSignal, this.monitor, backend, this.objectsLimit, this.idFetchSize));
        }
        executor.shutdown();
        this.endAllSignal.await();
    }

    private void afterBatch(BatchBackend backend) {
        Set targetedClasses = this.searchFactoryImplementor.getIndexedTypesPolymorphic((Class[])this.rootEntities);
        if (this.optimizeAtEnd) {
            backend.optimize(targetedClasses);
        }
        backend.flush(targetedClasses);
    }

    private void beforeBatch(BatchBackend backend) {
        if (this.purgeAtStart) {
            Set targetedClasses = this.searchFactoryImplementor.getIndexedTypesPolymorphic((Class[])this.rootEntities);
            for (Class clazz : targetedClasses) {
                backend.doWorkInSync((LuceneWork)new PurgeAllLuceneWork(clazz));
            }
            if (this.optimizeAfterPurge) {
                backend.optimize(targetedClasses);
            }
        }
    }
}

