/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.TimeoutManager;
import org.hibernate.search.query.hibernate.impl.AbstractLoader;
import org.hibernate.search.query.hibernate.impl.ObjectLoaderHelper;
import org.hibernate.search.query.hibernate.impl.ObjectsInitializer;

public class MultiClassesQueryLoader
extends AbstractLoader {
    private Session session;
    private SearchFactoryImplementor searchFactoryImplementor;
    private List<RootEntityMetadata> entityMatadata;
    private TimeoutManager timeoutManager;
    private ObjectsInitializer objectsInitializer;

    @Override
    public void init(Session session, SearchFactoryImplementor searchFactoryImplementor, ObjectsInitializer objectsInitializer, TimeoutManager timeoutManager) {
        super.init(session, searchFactoryImplementor);
        this.session = session;
        this.searchFactoryImplementor = searchFactoryImplementor;
        this.timeoutManager = timeoutManager;
        this.objectsInitializer = objectsInitializer;
    }

    @Override
    public boolean isSizeSafe() {
        return true;
    }

    public void setEntityTypes(Set<Class<?>> entityTypes) {
        ArrayList<Object> safeEntityTypes = new ArrayList<Object>();
        if (entityTypes.size() == 0) {
            for (Map.Entry entry : this.searchFactoryImplementor.getIndexBindings().entrySet()) {
                if (!((EntityIndexBinding)entry.getValue()).getDocumentBuilder().isRoot()) continue;
                safeEntityTypes.add(entry.getKey());
            }
        } else {
            safeEntityTypes.addAll(entityTypes);
        }
        this.entityMatadata = new ArrayList<RootEntityMetadata>(safeEntityTypes.size());
        for (Class clazz : safeEntityTypes) {
            this.entityMatadata.add(new RootEntityMetadata(clazz, this.searchFactoryImplementor));
        }
    }

    @Override
    public Object executeLoad(EntityInfo entityInfo) {
        Object result = ObjectLoaderHelper.load(entityInfo, this.session);
        this.timeoutManager.isTimedOut();
        return result;
    }

    @Override
    public List executeLoad(EntityInfo ... entityInfos) {
        if (entityInfos.length == 0) {
            return Collections.EMPTY_LIST;
        }
        if (entityInfos.length == 1) {
            Object entity = this.load(entityInfos[0]);
            if (entity == null) {
                return Collections.EMPTY_LIST;
            }
            List<Object> list = Collections.singletonList(entity);
            return list;
        }
        HashMap<RootEntityMetadata, ArrayList<EntityInfo>> entityinfoBuckets = new HashMap<RootEntityMetadata, ArrayList<EntityInfo>>(this.entityMatadata.size());
        for (EntityInfo entityInfo : entityInfos) {
            boolean found = false;
            Class clazz = entityInfo.getClazz();
            for (RootEntityMetadata rootEntityInfo : this.entityMatadata) {
                if (rootEntityInfo.rootEntity != clazz && !rootEntityInfo.mappedSubclasses.contains(clazz)) continue;
                ArrayList<EntityInfo> bucket = (ArrayList<EntityInfo>)entityinfoBuckets.get(rootEntityInfo);
                if (bucket == null) {
                    bucket = new ArrayList<EntityInfo>();
                    entityinfoBuckets.put(rootEntityInfo, bucket);
                }
                bucket.add(entityInfo);
                found = true;
                break;
            }
            if (found) continue;
            throw new AssertionFailure("Could not find root entity for " + clazz);
        }
        for (Map.Entry entry : entityinfoBuckets.entrySet()) {
            RootEntityMetadata key = (RootEntityMetadata)entry.getKey();
            List value = (List)entry.getValue();
            EntityInfo[] bucketEntityInfos = value.toArray(new EntityInfo[value.size()]);
            this.objectsInitializer.initializeObjects(bucketEntityInfos, key.criteria, key.rootEntity, this.searchFactoryImplementor, this.timeoutManager, this.session);
            this.timeoutManager.isTimedOut();
        }
        return ObjectLoaderHelper.returnAlreadyLoadedObjectsInCorrectOrder(entityInfos, this.session);
    }

    private static class RootEntityMetadata {
        public final Class<?> rootEntity;
        public final Set<Class<?>> mappedSubclasses;
        private final Criteria criteria;

        RootEntityMetadata(Class<?> rootEntity, SearchFactoryImplementor searchFactoryImplementor) {
            this.rootEntity = rootEntity;
            EntityIndexBinding provider = searchFactoryImplementor.getIndexBinding(rootEntity);
            if (provider == null) {
                throw new AssertionFailure("Provider not found for class: " + rootEntity);
            }
            this.mappedSubclasses = provider.getDocumentBuilder().getMappedSubclasses();
            this.criteria = null;
        }
    }
}

