/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.sql.Connection;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.Interceptor;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionEventListener;
import org.hibernate.SharedSessionBuilder;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.FullTextSharedSessionBuilder;
import org.hibernate.search.Search;

public class FullTextSharedSessionBuilderDelegator
implements FullTextSharedSessionBuilder {
    private final SharedSessionBuilder builder;

    public FullTextSharedSessionBuilderDelegator(SharedSessionBuilder builder) {
        this.builder = builder;
    }

    @Override
    public FullTextSharedSessionBuilder interceptor() {
        this.builder.interceptor();
        return this;
    }

    @Override
    public FullTextSharedSessionBuilder connection() {
        this.builder.connection();
        return this;
    }

    @Override
    public FullTextSharedSessionBuilder connectionReleaseMode() {
        this.builder.connectionReleaseMode();
        return this;
    }

    @Override
    public FullTextSharedSessionBuilder autoJoinTransactions() {
        this.builder.autoJoinTransactions();
        return this;
    }

    @Override
    public FullTextSharedSessionBuilder autoClose() {
        this.builder.autoClose();
        return this;
    }

    @Override
    public FullTextSharedSessionBuilder flushBeforeCompletion() {
        this.builder.flushBeforeCompletion();
        return this;
    }

    @Override
    public FullTextSharedSessionBuilder transactionContext() {
        this.builder.transactionContext();
        return this;
    }

    @Override
    public FullTextSharedSessionBuilder interceptor(Interceptor interceptor) {
        this.builder.interceptor(interceptor);
        return this;
    }

    @Override
    public FullTextSharedSessionBuilder noInterceptor() {
        this.builder.noInterceptor();
        return this;
    }

    @Override
    public FullTextSharedSessionBuilder connection(Connection connection) {
        this.builder.connection(connection);
        return this;
    }

    @Override
    public FullTextSharedSessionBuilder connectionReleaseMode(ConnectionReleaseMode connectionReleaseMode) {
        this.builder.connectionReleaseMode(connectionReleaseMode);
        return this;
    }

    @Override
    public FullTextSharedSessionBuilder autoJoinTransactions(boolean autoJoinTransactions) {
        this.builder.autoJoinTransactions(autoJoinTransactions);
        return this;
    }

    @Override
    public FullTextSharedSessionBuilder autoClose(boolean autoClose) {
        this.builder.autoClose(autoClose);
        return this;
    }

    @Override
    public FullTextSharedSessionBuilder flushBeforeCompletion(boolean flushBeforeCompletion) {
        this.builder.flushBeforeCompletion(flushBeforeCompletion);
        return this;
    }

    @Override
    public FullTextSession openSession() {
        return Search.getFullTextSession(this.builder.openSession());
    }

    @Override
    public FullTextSharedSessionBuilder tenantIdentifier(String tenantIdentifier) {
        this.builder.tenantIdentifier(tenantIdentifier);
        return this;
    }

    public SessionBuilder eventListeners(SessionEventListener ... listeners) {
        this.builder.eventListeners(listeners);
        return this;
    }

    public SessionBuilder clearEventListeners() {
        this.builder.clearEventListeners();
        return this;
    }
}

