/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing.impl;

import javax.transaction.SystemException;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.search.batchindexing.impl.BatchTransactionalContext;
import org.hibernate.search.batchindexing.impl.SessionAwareRunnable;
import org.hibernate.search.batchindexing.impl.StatelessSessionAwareRunnable;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class OptionallyWrapInJTATransaction
implements Runnable {
    private static final Log log = LoggerFactory.make();
    private final SessionAwareRunnable sessionAwareRunnable;
    private final StatelessSessionAwareRunnable statelessSessionAwareRunnable;
    private final BatchTransactionalContext batchContext;

    public OptionallyWrapInJTATransaction(BatchTransactionalContext batchContext, SessionAwareRunnable sessionAwareRunnable) {
        this.batchContext = batchContext;
        this.sessionAwareRunnable = sessionAwareRunnable;
        this.statelessSessionAwareRunnable = null;
    }

    public OptionallyWrapInJTATransaction(BatchTransactionalContext batchContext, StatelessSessionAwareRunnable statelessSessionAwareRunnable) {
        this.batchContext = batchContext;
        this.sessionAwareRunnable = null;
        this.statelessSessionAwareRunnable = statelessSessionAwareRunnable;
    }

    @Override
    public void run() {
        block14: {
            try {
                boolean wrapInTransaction = this.batchContext.wrapInTransaction();
                if (wrapInTransaction) {
                    try {
                        StatelessSession statelessSession;
                        Session session;
                        if (this.sessionAwareRunnable != null) {
                            session = this.batchContext.factory.openSession();
                            statelessSession = null;
                        } else {
                            session = null;
                            statelessSession = this.batchContext.factory.openStatelessSession();
                        }
                        this.batchContext.transactionManager.begin();
                        if (this.sessionAwareRunnable != null) {
                            this.sessionAwareRunnable.run(session);
                        } else {
                            this.statelessSessionAwareRunnable.run(statelessSession);
                        }
                        this.batchContext.transactionManager.commit();
                        if (this.sessionAwareRunnable != null) {
                            session.close();
                            break block14;
                        }
                        statelessSession.close();
                    }
                    catch (Throwable e) {
                        this.batchContext.errorHandler.handleException(log.massIndexerUnexpectedErrorMessage(), e);
                        try {
                            this.batchContext.transactionManager.rollback();
                            break block14;
                        }
                        catch (SystemException e1) {
                            log.errorRollingBackTransaction(e.getMessage(), (Exception)((Object)e1));
                        }
                    }
                    break block14;
                }
                if (this.sessionAwareRunnable != null) {
                    this.sessionAwareRunnable.run(null);
                } else {
                    this.statelessSessionAwareRunnable.run(null);
                }
            }
            catch (Throwable e) {
                this.batchContext.errorHandler.handleException(log.massIndexerUnexpectedErrorMessage(), e);
            }
        }
    }
}

