/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.hcore.impl;

import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.Version;
import org.hibernate.search.cfg.impl.SearchConfigurationFromHibernateCore;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.event.impl.FullTextIndexEventListener;
import org.hibernate.search.jmx.IndexControl;
import org.hibernate.search.jmx.impl.JMXRegistrar;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class HibernateSearchSessionFactoryObserver
implements SessionFactoryObserver {
    public static final String SESSION_FACTORY_PROPERTY_KEY = "hibernate.search.hcore.session_factory";
    private static final Log log;
    private Configuration configuration;
    private final FullTextIndexEventListener listener;
    private String indexControlMBeanName;
    private SearchFactoryImplementor searchFactoryImplementor;

    public HibernateSearchSessionFactoryObserver(Configuration configuration, FullTextIndexEventListener listener) {
        this.configuration = configuration;
        this.listener = listener;
    }

    public void sessionFactoryCreated(SessionFactory factory) {
        try {
            String enableJMX;
            this.configuration.getProperties().put(SESSION_FACTORY_PROPERTY_KEY, factory);
            if (this.searchFactoryImplementor == null) {
                this.searchFactoryImplementor = new SearchFactoryBuilder().configuration((SearchConfiguration)new SearchConfigurationFromHibernateCore(this.configuration)).buildSearchFactory();
            }
            if ("true".equalsIgnoreCase(enableJMX = this.configuration.getProperty("hibernate.search.jmx_enabled"))) {
                this.enableIndexControlBean();
            }
            this.configuration = null;
            this.listener.initialize(this.searchFactoryImplementor);
        }
        catch (RuntimeException e) {
            factory.close();
            throw e;
        }
    }

    public void sessionFactoryClosed(SessionFactory factory) {
        if (this.searchFactoryImplementor != null) {
            this.searchFactoryImplementor.close();
        }
        if (this.indexControlMBeanName != null) {
            JMXRegistrar.unRegisterMBean((String)this.indexControlMBeanName);
        }
    }

    private void enableIndexControlBean() {
        if (StringHelper.isEmpty((String)this.configuration.getProperty("hibernate.session_factory_name"))) {
            log.debug((Object)"In order to bind the IndexControlMBean the Hibernate SessionFactory has to be available via JNDI");
            return;
        }
        String mbeanNameSuffix = this.configuration.getProperty("hibernate.search.jmx_bean_suffix");
        String objectName = JMXRegistrar.buildMBeanName((String)"org.hibernate.search.jmx:type=IndexControlMBean", (String)mbeanNameSuffix);
        if (JMXRegistrar.isNameRegistered((String)objectName)) {
            JMXRegistrar.unRegisterMBean((String)objectName);
        }
        IndexControl indexCtrlBean = new IndexControl(this.configuration.getProperties());
        JMXRegistrar.registerMBean((Object)indexCtrlBean, (String)objectName);
        this.indexControlMBeanName = objectName;
    }

    static {
        Version.touch();
        log = LoggerFactory.make();
    }
}

