/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.hibernate.search.annotations.Boost;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

@Entity
@Indexed(index="Documents")
public class Document {
    private Long id;
    private String title;
    private String summary;
    private String text;

    public Document() {
    }

    public Document(String title, String summary, String text) {
        this.summary = summary;
        this.text = text;
        this.title = title;
    }

    @Id
    @GeneratedValue
    @DocumentId
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Field(store=Store.YES)
    @Boost(value=2.0f)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Field(name="Abstract")
    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Field
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }
}

