/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer;

import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.de.GermanStemFilterFactory;
import org.apache.lucene.analysis.snowball.SnowballPorterFilterFactory;
import org.apache.lucene.analysis.standard.StandardTokenizerFactory;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.AnalyzerDefs;
import org.hibernate.search.annotations.AnalyzerDiscriminator;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.test.analyzer.LanguageDiscriminator;

@Entity
@Indexed
@AnalyzerDefs(value={@AnalyzerDef(name="en", tokenizer=@TokenizerDef(factory=StandardTokenizerFactory.class), filters={@TokenFilterDef(factory=LowerCaseFilterFactory.class), @TokenFilterDef(factory=SnowballPorterFilterFactory.class)}), @AnalyzerDef(name="de", tokenizer=@TokenizerDef(factory=StandardTokenizerFactory.class), filters={@TokenFilterDef(factory=LowerCaseFilterFactory.class), @TokenFilterDef(factory=GermanStemFilterFactory.class)})})
@AnalyzerDiscriminator(impl=LanguageDiscriminator.class)
public class BlogEntry {
    private Integer id;
    private String language;
    private String text;
    private Set<BlogEntry> references;

    @Id
    @GeneratedValue
    @DocumentId
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Field(store=Store.YES)
    @AnalyzerDiscriminator(impl=LanguageDiscriminator.class)
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    @Field(store=Store.YES)
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @OneToMany(cascade={CascadeType.ALL})
    @IndexedEmbedded(depth=1)
    public Set<BlogEntry> getReferences() {
        return this.references;
    }

    public void setReferences(Set<BlogEntry> references) {
        this.references = references;
    }
}

