/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer;

import java.io.Reader;
import java.util.Map;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeSource;
import org.hibernate.search.test.analyzer.StreamWrappingTokenizer;

public abstract class TestTokenizer
extends TokenizerFactory {
    protected TestTokenizer(Map<String, String> args) {
        super(args);
        this.assureMatchVersion();
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public abstract StreamWrappingTokenizer create(AttributeSource.AttributeFactory var1, Reader var2);

    public static class TestTokenizer3
    extends TestTokenizer {
        public TestTokenizer3(Map<String, String> args) {
            super(args);
        }

        @Override
        public StreamWrappingTokenizer create(AttributeSource.AttributeFactory factory, Reader input) {
            return new StreamWrappingTokenizer(input, new String[]{"mouse"});
        }
    }

    public static class TestTokenizer2
    extends TestTokenizer {
        public TestTokenizer2(Map<String, String> args) {
            super(args);
        }

        @Override
        public StreamWrappingTokenizer create(AttributeSource.AttributeFactory factory, Reader input) {
            return new StreamWrappingTokenizer(input, new String[]{"cat"});
        }
    }

    public static class TestTokenizer1
    extends TestTokenizer {
        public TestTokenizer1(Map<String, String> args) {
            super(args);
        }

        @Override
        public StreamWrappingTokenizer create(AttributeSource.AttributeFactory factory, Reader input) {
            return new StreamWrappingTokenizer(input, new String[]{"dog"});
        }
    }
}

