/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.batchindexing;

import java.util.Set;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.batchindexing.impl.MassIndexerImpl;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.test.batchindexing.AncientBook;
import org.hibernate.search.test.batchindexing.Book;
import org.hibernate.search.test.batchindexing.Dvd;
import org.hibernate.search.test.batchindexing.ExtendedIssueEntity;
import org.hibernate.search.test.batchindexing.IssueEntity;
import org.hibernate.search.test.batchindexing.ModernBook;
import org.hibernate.search.test.batchindexing.Nation;
import org.hibernate.search.test.batchindexing.WeirdlyIdentifiedEntity;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

public class SearchIndexerTest {
    @Test
    public void testEntityHierarchy() {
        FullTextSessionBuilder ftsb = new FullTextSessionBuilder().addAnnotatedClass(ModernBook.class).addAnnotatedClass(AncientBook.class).addAnnotatedClass(Dvd.class).addAnnotatedClass(Book.class).addAnnotatedClass(Nation.class).build();
        FullTextSession fullTextSession = ftsb.openFullTextSession();
        SearchFactoryImplementor searchFactory = (SearchFactoryImplementor)fullTextSession.getSearchFactory();
        TestableMassIndexerImpl tsii = new TestableMassIndexerImpl(searchFactory, Book.class);
        Assert.assertTrue((boolean)tsii.getRootEntities().contains(Book.class));
        Assert.assertFalse((boolean)tsii.getRootEntities().contains(ModernBook.class));
        Assert.assertFalse((boolean)tsii.getRootEntities().contains(AncientBook.class));
        tsii = new TestableMassIndexerImpl(searchFactory, ModernBook.class, AncientBook.class, Book.class);
        Assert.assertTrue((boolean)tsii.getRootEntities().contains(Book.class));
        Assert.assertFalse((boolean)tsii.getRootEntities().contains(ModernBook.class));
        Assert.assertFalse((boolean)tsii.getRootEntities().contains(AncientBook.class));
        tsii = new TestableMassIndexerImpl(searchFactory, ModernBook.class, AncientBook.class);
        Assert.assertFalse((boolean)tsii.getRootEntities().contains(Book.class));
        Assert.assertTrue((boolean)tsii.getRootEntities().contains(ModernBook.class));
        Assert.assertTrue((boolean)tsii.getRootEntities().contains(AncientBook.class));
        tsii = new TestableMassIndexerImpl(searchFactory, Object.class);
        Assert.assertTrue((boolean)tsii.getRootEntities().contains(Book.class));
        Assert.assertTrue((boolean)tsii.getRootEntities().contains(Dvd.class));
        Assert.assertFalse((boolean)tsii.getRootEntities().contains(AncientBook.class));
        Assert.assertFalse((boolean)tsii.getRootEntities().contains(Object.class));
        Assert.assertEquals((long)2L, (long)tsii.getRootEntities().size());
        fullTextSession.close();
        ftsb.close();
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-901")
    public void testIdentifierNaming() throws InterruptedException {
        FullTextSessionBuilder ftsb = new FullTextSessionBuilder().setProperty("hibernate.search.analyzer", StandardAnalyzer.class.getName()).addAnnotatedClass(Dvd.class).addAnnotatedClass(Nation.class).addAnnotatedClass(Book.class).addAnnotatedClass(WeirdlyIdentifiedEntity.class).setProperty("hibernate.search.indexing_strategy", "manual").build();
        FullTextSession fullTextSession = ftsb.openFullTextSession();
        Transaction transaction = fullTextSession.beginTransaction();
        Nation us = new Nation("United States of America", "US");
        fullTextSession.persist((Object)us);
        Dvd dvda = new Dvd();
        dvda.setTitle("Star Trek (episode 96367)");
        dvda.setFirstPublishedIn(us);
        fullTextSession.save((Object)dvda);
        Dvd dvdb = new Dvd();
        dvdb.setTitle("The Trek");
        dvdb.setFirstPublishedIn(us);
        fullTextSession.save((Object)dvdb);
        WeirdlyIdentifiedEntity entity = new WeirdlyIdentifiedEntity();
        entity.setId("not an identifier");
        fullTextSession.save((Object)entity);
        transaction.commit();
        fullTextSession.close();
        Assert.assertEquals((long)0L, (long)this.countResults(new Term("title", "trek"), ftsb, Dvd.class));
        Assert.assertEquals((long)0L, (long)this.countResults(new Term("id", "not"), ftsb, WeirdlyIdentifiedEntity.class));
        fullTextSession = ftsb.openFullTextSession();
        fullTextSession.createIndexer(new Class[]{Dvd.class}).startAndWait();
        fullTextSession.close();
        Assert.assertEquals((long)2L, (long)this.countResults(new Term("title", "trek"), ftsb, Dvd.class));
        fullTextSession = ftsb.openFullTextSession();
        fullTextSession.createIndexer(new Class[]{WeirdlyIdentifiedEntity.class}).startAndWait();
        fullTextSession.close();
        Assert.assertEquals((long)1L, (long)this.countResults(new Term("id", "identifier"), ftsb, WeirdlyIdentifiedEntity.class));
        ftsb.close();
    }

    @Test
    public void testExtendedIdentifierNaming() throws InterruptedException {
        FullTextSessionBuilder ftsb = new FullTextSessionBuilder().setProperty("hibernate.search.analyzer", StandardAnalyzer.class.getName()).addAnnotatedClass(ExtendedIssueEntity.class).addAnnotatedClass(IssueEntity.class).setProperty("hibernate.search.indexing_strategy", "manual").build();
        FullTextSession fullTextSession = ftsb.openFullTextSession();
        Transaction transaction = fullTextSession.beginTransaction();
        ExtendedIssueEntity issue = new ExtendedIssueEntity();
        issue.jiraCode = "HSEARCH-977";
        issue.jiraDescription = "MassIndexer freezes when there is an indexed 'id' filed, which is not document's id";
        issue.id = 1L;
        fullTextSession.persist((Object)issue);
        transaction.commit();
        fullTextSession.close();
        Assert.assertEquals((long)0L, (long)this.countResults(new Term("jiraDescription", "freezes"), ftsb, ExtendedIssueEntity.class));
        Assert.assertEquals((long)0L, (long)this.countResults(new Term("jiraCode", "HSEARCH"), ftsb, ExtendedIssueEntity.class));
        fullTextSession = ftsb.openFullTextSession();
        fullTextSession.createIndexer(new Class[]{ExtendedIssueEntity.class}).startAndWait();
        fullTextSession.close();
        Assert.assertEquals((long)1L, (long)this.countResults(new Term("jiraDescription", "freezes"), ftsb, ExtendedIssueEntity.class));
        Assert.assertEquals((long)1L, (long)this.countResults(new Term("id", "1"), ftsb, ExtendedIssueEntity.class));
        ftsb.close();
    }

    private int countResults(Term termForQuery, FullTextSessionBuilder ftSessionBuilder, Class<?> type) {
        TermQuery fullTextQuery = new TermQuery(termForQuery);
        FullTextSession fullTextSession = ftSessionBuilder.openFullTextSession();
        Transaction transaction = fullTextSession.beginTransaction();
        FullTextQuery query = fullTextSession.createFullTextQuery((Query)fullTextQuery, new Class[]{type});
        int resultSize = query.getResultSize();
        transaction.commit();
        fullTextSession.close();
        return resultSize;
    }

    private static class TestableMassIndexerImpl
    extends MassIndexerImpl {
        protected TestableMassIndexerImpl(SearchFactoryImplementor searchFactory, Class<?> ... types) {
            super(searchFactory, null, (Class[])types);
        }

        public Set<Class<?>> getRootEntities() {
            return this.rootEntities;
        }
    }
}

