/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.compression;

import java.util.List;
import java.util.zip.DataFormatException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.document.CompressionTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.BytesRef;
import org.hibernate.Session;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.compression.LargeDocument;
import org.hibernate.search.testsupport.TestConstants;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompressionTest
extends SearchTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFieldWasCompressed() throws Exception {
        IndexReader indexReader = this.getSearchFactory().getIndexReaderAccessor().open(new Class[]{LargeDocument.class});
        try {
            IndexSearcher searcher = new IndexSearcher(indexReader);
            TopDocs topDocs = searcher.search((Query)new MatchAllDocsQuery(), null, 10);
            Assert.assertEquals((long)1L, (long)topDocs.totalHits);
            ScoreDoc doc = topDocs.scoreDocs[0];
            Document document = indexReader.document(doc.doc);
            IndexableField[] fields = document.getFields("title");
            Assert.assertEquals((long)1L, (long)fields.length);
            Assert.assertTrue((boolean)fields[0].fieldType().indexed());
            Assert.assertTrue((boolean)fields[0].fieldType().stored());
            Assert.assertFalse((boolean)this.isCompressed(fields[0]));
            Assert.assertEquals((Object)"Hibernate in Action, third edition", (Object)fields[0].stringValue());
            fields = document.getFields("abstract");
            Assert.assertEquals((long)1L, (long)fields.length);
            Assert.assertTrue((boolean)this.isCompressed(fields[0]));
            Assert.assertEquals((Object)"<b>JPA2 with Hibernate</b>", (Object)this.restoreValue(fields[0]));
            fields = document.getFields("text");
            Assert.assertEquals((long)1L, (long)fields.length);
            Assert.assertTrue((boolean)this.isCompressed(fields[0]));
            Assert.assertEquals((Object)"This is a placeholder for the new text that you should write", (Object)this.restoreValue(fields[0]));
        }
        finally {
            this.getSearchFactory().getIndexReaderAccessor().close(indexReader);
        }
    }

    @Test
    public void testCompressedFieldSearch() throws Exception {
        this.assertFindsN(1, "title:third");
        this.assertFindsN(1, "abstract:jpa2");
        this.assertFindsN(1, "text:write");
        this.assertFindsN(0, "text:jpa2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertFindsN(int expectedToFind, String queryString) throws ParseException {
        this.openSession().beginTransaction();
        try {
            FullTextSession fullTextSession = Search.getFullTextSession((Session)this.getSession());
            QueryParser queryParser = new QueryParser(TestConstants.getTargetLuceneVersion(), "", (Analyzer)new SimpleAnalyzer(TestConstants.getTargetLuceneVersion()));
            Query query = queryParser.parse(queryString);
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{LargeDocument.class});
            List list = fullTextQuery.list();
            Assert.assertEquals((long)expectedToFind, (long)list.size());
            if (expectedToFind == 1) {
                Assert.assertEquals((Object)"Hibernate in Action, third edition", (Object)((LargeDocument)list.get(0)).getTitle());
            }
        }
        finally {
            this.getSession().getTransaction().commit();
            this.getSession().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProjectionOnCompressedFields() {
        this.openSession().beginTransaction();
        try {
            FullTextSession fullTextSession = Search.getFullTextSession((Session)this.getSession());
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[]{LargeDocument.class});
            List list = fullTextQuery.setProjection(new String[]{"title", "abstract", "text"}).list();
            Assert.assertEquals((long)1L, (long)list.size());
            Object[] results = (Object[])list.get(0);
            Assert.assertEquals((Object)"Hibernate in Action, third edition", (Object)results[0]);
            Assert.assertEquals((Object)"JPA2 with Hibernate", (Object)results[1]);
            Assert.assertEquals((Object)"This is a placeholder for the new text that you should write", (Object)results[2]);
        }
        finally {
            this.getSession().getTransaction().commit();
            this.getSession().close();
        }
    }

    private String restoreValue(IndexableField field) throws DataFormatException {
        if (field.binaryValue() != null) {
            Assert.assertNull((String)"we rely on this in the Projection implementation", (Object)field.stringValue());
            return CompressionTools.decompressString((BytesRef)field.binaryValue());
        }
        return field.stringValue();
    }

    private boolean isCompressed(IndexableField field) {
        if (field.binaryValue() == null) {
            return false;
        }
        try {
            CompressionTools.decompressString((BytesRef)field.binaryValue());
            return true;
        }
        catch (DataFormatException e) {
            return false;
        }
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{LargeDocument.class};
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Session s = this.openSession();
        s.getTransaction().begin();
        s.persist((Object)new LargeDocument("Hibernate in Action, third edition", "JPA2 with Hibernate", "This is a placeholder for the new text that you should write"));
        s.getTransaction().commit();
        s.close();
    }
}

