/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.backend.impl.lucene.AbstractWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.ExclusiveIndexWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueProcessor;
import org.hibernate.search.backend.impl.lucene.SharedIndexWorkspaceImpl;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.test.configuration.BlogEntry;
import org.hibernate.search.test.query.Author;
import org.hibernate.search.test.query.Book;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.junit.Assert;
import org.junit.Test;

public class ExclusiveIndexTest {
    @Test
    public void verifyIndexExclusivity() {
        FullTextSessionBuilder builder = new FullTextSessionBuilder();
        FullTextSession ftSession = builder.setProperty("hibernate.search.org.hibernate.search.test.configuration.BlogEntry.exclusive_index_use", "true").setProperty("hibernate.search.Book.exclusive_index_use", "false").addAnnotatedClass(BlogEntry.class).addAnnotatedClass(Foo.class).addAnnotatedClass(Book.class).addAnnotatedClass(Author.class).openFullTextSession();
        SearchFactoryImplementor searchFactory = (SearchFactoryImplementor)ftSession.getSearchFactory();
        ftSession.close();
        IndexManagerHolder allIndexesManager = searchFactory.getIndexManagerHolder();
        this.assertExclusiveIsEnabled(allIndexesManager, "org.hibernate.search.test.configuration.BlogEntry", true);
        this.assertExclusiveIsEnabled(allIndexesManager, "Book", false);
        this.assertExclusiveIsEnabled(allIndexesManager, Foo.class.getName(), true);
        builder.close();
    }

    private void assertExclusiveIsEnabled(IndexManagerHolder allIndexesManager, String indexName, boolean expectExclusive) {
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)allIndexesManager.getIndexManager(indexName);
        BackendQueueProcessor backendQueueProcessor = indexManager.getBackendQueueProcessor();
        Assert.assertEquals(LuceneBackendQueueProcessor.class, backendQueueProcessor.getClass());
        LuceneBackendQueueProcessor backend = (LuceneBackendQueueProcessor)backendQueueProcessor;
        AbstractWorkspaceImpl workspace = backend.getIndexResources().getWorkspace();
        if (expectExclusive) {
            Assert.assertEquals(ExclusiveIndexWorkspaceImpl.class, workspace.getClass());
        } else {
            Assert.assertEquals(SharedIndexWorkspaceImpl.class, workspace.getClass());
        }
    }

    @Indexed
    @Entity
    @Table(name="Foo")
    public static class Foo {
        @Id
        private int id;
    }
}

