/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.path.validation;

import org.hibernate.search.exception.SearchException;
import org.hibernate.search.test.embedded.path.validation.A;
import org.hibernate.search.test.embedded.path.validation.B;
import org.hibernate.search.test.embedded.path.validation.C;
import org.hibernate.search.test.embedded.path.validation.DeepPathSimpleTypeCase;
import org.hibernate.search.test.embedded.path.validation.DeepPathWithLeadingPrefixCase;
import org.hibernate.search.test.embedded.path.validation.DepthExceedsPathTestCase;
import org.hibernate.search.test.embedded.path.validation.DepthMatchesPathDepthCase;
import org.hibernate.search.test.embedded.path.validation.FieldRenamedContainerEntity;
import org.hibernate.search.test.embedded.path.validation.FieldRenamedEmbeddedEntity;
import org.hibernate.search.test.embedded.path.validation.InvalidEmbeddedNonLeafCase;
import org.hibernate.search.test.embedded.path.validation.InvalidEmbeddedPathCase;
import org.hibernate.search.test.embedded.path.validation.InvalidEmbeddedWithoutPathsCase;
import org.hibernate.search.test.embedded.path.validation.InvalidNonLeafUseCase;
import org.hibernate.search.test.embedded.path.validation.InvalidPrefixCase;
import org.hibernate.search.test.embedded.path.validation.InvalidShallowPathCase;
import org.hibernate.search.test.embedded.path.validation.PathNotIndexedCase;
import org.hibernate.search.test.embedded.path.validation.ReferencesC;
import org.hibernate.search.test.embedded.path.validation.ReferencesIndexedEmbeddedA;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.junit.Assert;
import org.junit.Test;

public class TestInvalidPaths {
    @Test
    public void testInvalidDeepSimplePath() {
        FullTextSessionBuilder cfg = new FullTextSessionBuilder();
        cfg.addAnnotatedClass(A.class);
        cfg.addAnnotatedClass(B.class);
        cfg.addAnnotatedClass(C.class);
        cfg.addAnnotatedClass(DeepPathSimpleTypeCase.class);
        try {
            cfg.build();
            Assert.fail((String)"Exception should have been thrown for DeepPathSimpleTypeCase having invalid path: b.c.dne");
        }
        catch (SearchException se) {
            Assert.assertTrue((String)"Expected search exception to contain information about invalid path b.c.dne", (boolean)se.getMessage().contains("b.c.dne"));
        }
    }

    @Test
    public void testInvalidDeepSimplePathWithLeadingPrefix() {
        FullTextSessionBuilder cfg = new FullTextSessionBuilder();
        cfg.addAnnotatedClass(A.class);
        cfg.addAnnotatedClass(B.class);
        cfg.addAnnotatedClass(C.class);
        cfg.addAnnotatedClass(DeepPathWithLeadingPrefixCase.class);
        try {
            cfg.build();
            Assert.fail((String)"Exception should have been thrown for DeepPathWithLeadingPrefixCase having invalid path: b.c.dne");
        }
        catch (SearchException se) {
            Assert.assertTrue((String)("Should contain information about invalid path b.c.dne (message: <" + se.getMessage() + ">)"), (boolean)se.getMessage().matches(".*\\[b.c.dne\\].*"));
            Assert.assertFalse((String)("Should NOT contain information about invalid path prefix: notJustA (message: <" + se.getMessage() + ">)"), (boolean)se.getMessage().contains("notJustA"));
        }
    }

    @Test
    public void testInvalidPrefix() {
        FullTextSessionBuilder cfg = new FullTextSessionBuilder();
        cfg.addAnnotatedClass(A.class);
        cfg.addAnnotatedClass(B.class);
        cfg.addAnnotatedClass(C.class);
        cfg.addAnnotatedClass(InvalidPrefixCase.class);
        try {
            cfg.build();
            Assert.fail((String)"Exception should have been thrown for InvalidPrefixCase having invalid path: b.c.dne");
        }
        catch (SearchException se) {
            Assert.assertTrue((String)"Expected search exception to contain information about invalid path a.b.c.indexed", (boolean)se.getMessage().contains("a.b.c.indexed"));
        }
    }

    @Test
    public void testShallowInvalidPath() throws Exception {
        FullTextSessionBuilder cfg = new FullTextSessionBuilder();
        cfg.addAnnotatedClass(A.class);
        cfg.addAnnotatedClass(B.class);
        cfg.addAnnotatedClass(C.class);
        cfg.addAnnotatedClass(InvalidShallowPathCase.class);
        try {
            cfg.build();
            Assert.fail((String)"Exception should have been thrown for ShallowPathCase having invalid path: dne");
        }
        catch (SearchException se) {
            Assert.assertTrue((String)"Expected search exception to contain information about invalid path dne", (boolean)se.getMessage().contains("dne"));
        }
    }

    @Test
    public void testNonLeafPathInvalid() {
        FullTextSessionBuilder cfg = new FullTextSessionBuilder();
        cfg.addAnnotatedClass(A.class);
        cfg.addAnnotatedClass(B.class);
        cfg.addAnnotatedClass(C.class);
        cfg.addAnnotatedClass(InvalidNonLeafUseCase.class);
        try {
            cfg.build();
            Assert.fail((String)"Exception should have been thrown for D having invalid path: b.c");
        }
        catch (SearchException se) {
            Assert.assertTrue((String)"Expected search exception to contain information about invalid path b.c", (boolean)se.getMessage().contains("b.c"));
        }
    }

    @Test
    public void testEmbeddedPathValidation() {
        FullTextSessionBuilder cfg = new FullTextSessionBuilder();
        cfg.addAnnotatedClass(A.class);
        cfg.addAnnotatedClass(B.class);
        cfg.addAnnotatedClass(C.class);
        cfg.addAnnotatedClass(InvalidEmbeddedWithoutPathsCase.class);
        cfg.addAnnotatedClass(InvalidEmbeddedPathCase.class);
        try {
            cfg.build();
            Assert.fail((String)"Exception should have been thrown for InvalidEmbeddedPathsCase having invalid path: emb.e4");
        }
        catch (SearchException se) {
            Assert.assertTrue((String)("Expected search exception to contain information about invalid path emb.e4, instead got error: " + se.getMessage()), (boolean)se.getMessage().contains("emb.e4"));
            Assert.assertFalse((String)("Expected search exception to NOT contain information about invalid path emb.e1, instead got error: " + se.getMessage()), (boolean)se.getMessage().contains("emb.e1"));
        }
    }

    @Test
    public void testNonLeafEmbeddedPath() {
        FullTextSessionBuilder cfg = new FullTextSessionBuilder();
        cfg.addAnnotatedClass(A.class);
        cfg.addAnnotatedClass(B.class);
        cfg.addAnnotatedClass(C.class);
        cfg.addAnnotatedClass(InvalidEmbeddedWithoutPathsCase.class);
        cfg.addAnnotatedClass(InvalidEmbeddedNonLeafCase.class);
        try {
            cfg.build();
            Assert.fail((String)"Exception should have been thrown for InvalidEmbeddedNonLeafCase having invalid path: emb.e3");
        }
        catch (SearchException se) {
            Assert.assertTrue((String)("Expected search exception to contain information about invalid leaf path emb.e3, instead got error: " + se.getMessage()), (boolean)se.getMessage().contains("emb.e3"));
            Assert.assertFalse((String)("Expected search exception to NOT contain information about invalid path emb.e1, instead got error: " + se.getMessage()), (boolean)se.getMessage().contains("emb.e1"));
        }
    }

    @Test
    public void testNonIndexedPath() {
        FullTextSessionBuilder cfg = new FullTextSessionBuilder();
        cfg.addAnnotatedClass(A.class);
        cfg.addAnnotatedClass(B.class);
        cfg.addAnnotatedClass(C.class);
        cfg.addAnnotatedClass(ReferencesC.class);
        cfg.addAnnotatedClass(PathNotIndexedCase.class);
        try {
            cfg.build();
            Assert.fail((String)"Exception should have been thrown for PathNotIndexedCase having invalid path: c.indexed");
        }
        catch (SearchException se) {
            Assert.assertTrue((String)("Expected search exception to contain information about invalid leaf path c.indexed, instead got error: " + se.getMessage()), (boolean)se.getMessage().contains("c.indexed"));
        }
    }

    @Test
    public void testRenamedFieldInPath() {
        FullTextSessionBuilder cfg = new FullTextSessionBuilder();
        cfg.addAnnotatedClass(FieldRenamedContainerEntity.class);
        cfg.addAnnotatedClass(FieldRenamedEmbeddedEntity.class);
        try {
            cfg.build();
            Assert.fail((String)"Exception should have been thrown for FieldRenamedContainerEntity having invalid path (attribute instead of field name): embedded.field");
        }
        catch (SearchException se) {
            Assert.assertTrue((String)("Expected search exception to contain information about invalid leaf path embedded.field, instead got error: " + se.getMessage()), (boolean)se.getMessage().contains("embedded.field"));
        }
    }

    @Test
    public void testDepthMatchesPathMarkedAsEncountered() {
        FullTextSessionBuilder cfg = new FullTextSessionBuilder();
        cfg.addAnnotatedClass(A.class);
        cfg.addAnnotatedClass(B.class);
        cfg.addAnnotatedClass(C.class);
        cfg.addAnnotatedClass(ReferencesIndexedEmbeddedA.class);
        cfg.addAnnotatedClass(DepthMatchesPathDepthCase.class);
        cfg.build();
    }

    @Test
    public void testDepthExceedsPathMarkedAsEncountered() {
        FullTextSessionBuilder cfg = new FullTextSessionBuilder();
        cfg.addAnnotatedClass(A.class);
        cfg.addAnnotatedClass(B.class);
        cfg.addAnnotatedClass(C.class);
        cfg.addAnnotatedClass(ReferencesIndexedEmbeddedA.class);
        cfg.addAnnotatedClass(DepthExceedsPathTestCase.class);
        cfg.build();
    }
}

