/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.update;

import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.embedded.update.Dad;
import org.hibernate.search.test.embedded.update.Grandpa;
import org.hibernate.search.test.embedded.update.Son;
import org.junit.Assert;
import org.junit.Test;

public class ContainedInReindexPropagationTest
extends SearchTestBase {
    @Test
    public void testUpdatingContainedInEntityPropagatesToAllEntities() throws Exception {
        Grandpa source = new Grandpa("grandpaSource");
        Grandpa target = new Grandpa("grandpaTarget");
        Dad dad1 = new Dad("dad1");
        dad1.setGrandpa(source);
        Dad dad2 = new Dad("dad2");
        dad2.setGrandpa(source);
        Son son1 = new Son("son1");
        dad1.add(son1);
        Son son2 = new Son("son2");
        dad2.add(son2);
        FullTextSession session = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = session.beginTransaction();
        session.save((Object)source);
        session.save((Object)target);
        session.save((Object)dad1);
        session.save((Object)dad2);
        session.save((Object)son1);
        session.save((Object)son2);
        tx.commit();
        session.close();
        Long sourceGrandpaId = source.getId();
        Long targetGrandpaId = target.getId();
        session = Search.getFullTextSession((Session)this.openSession());
        tx = session.beginTransaction();
        Assert.assertEquals((Object)this.getSonsGrandpaIdFromIndex(session, son1.getName()), (Object)sourceGrandpaId);
        Assert.assertEquals((Object)this.getSonsGrandpaIdFromIndex(session, son2.getName()), (Object)sourceGrandpaId);
        tx.commit();
        session.close();
        dad1.setGrandpa(target);
        dad2.setGrandpa(target);
        session = Search.getFullTextSession((Session)this.openSession());
        tx = session.beginTransaction();
        session.update((Object)dad1);
        session.update((Object)dad2);
        tx.commit();
        session.close();
        session = Search.getFullTextSession((Session)this.openSession());
        tx = session.beginTransaction();
        Assert.assertEquals((String)"must now point target!", (Object)this.getSonsGrandpaIdFromIndex(session, son2.getName()), (Object)targetGrandpaId);
        Assert.assertEquals((String)"must now point target!", (Object)this.getSonsGrandpaIdFromIndex(session, son1.getName()), (Object)targetGrandpaId);
        tx.commit();
        session.close();
    }

    private Long getSonsGrandpaIdFromIndex(FullTextSession session, String name) {
        FullTextQuery q = session.createFullTextQuery((Query)new TermQuery(new Term("name", name)), new Class[]{Son.class});
        q.setProjection(new String[]{"dad.grandpaId"});
        List results = q.list();
        if (results.isEmpty()) {
            return null;
        }
        return (Long)((Object[])results.get(0))[0];
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Dad.class, Grandpa.class, Son.class};
    }
}

