/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.update;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.test.embedded.fieldoncollection.CollectionOfStringsFieldBridge;
import org.hibernate.search.test.embedded.update.ProductArticle;
import org.hibernate.search.test.embedded.update.ProductModel;

@Entity
@Indexed
public class ProductShootingBrief {
    @Id
    @GeneratedValue
    private Long id;
    private String name;
    @OneToMany(mappedBy="shootingBrief", fetch=FetchType.LAZY)
    private Set<ProductArticle> articles = new HashSet<ProductArticle>();
    @OneToMany(mappedBy="shootingBrief", fetch=FetchType.LAZY)
    private Set<ProductModel> models = new HashSet<ProductModel>();

    protected ProductShootingBrief() {
    }

    public ProductShootingBrief(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<ProductArticle> getArticles() {
        return this.articles;
    }

    public void setArticles(Set<ProductArticle> articles) {
        this.articles = articles;
    }

    public Set<ProductModel> getModels() {
        return this.models;
    }

    public void setModels(Set<ProductModel> models) {
        this.models = models;
    }

    @Transient
    @Field(bridge=@FieldBridge(impl=CollectionOfStringsFieldBridge.class), analyzer=@Analyzer(impl=StandardAnalyzer.class))
    public Collection<String> getReferenceCodeCollection() {
        ArrayList<String> referenceCodes = new ArrayList<String>();
        for (ProductArticle article : this.articles) {
            referenceCodes.addAll(article.getProductReferenceCodeWithColorCollection());
        }
        for (ProductModel model : this.models) {
            referenceCodes.addAll(model.getProductReferenceCodeCollection());
            for (ProductArticle article : model.getArticles()) {
                if (article.getShootingBrief() != null) continue;
                referenceCodes.addAll(article.getProductReferenceCodeWithColorCollection());
            }
        }
        return Collections.unmodifiableCollection(referenceCodes);
    }
}

