/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.test.engine.BusStop;

@Entity
@Indexed
public class BusLine {
    private Long id;
    private String busLineName;
    private Set<BusStop> stops = new HashSet<BusStop>();
    private Integer busLineCode = 0;
    private boolean operating = true;

    @Id
    @GeneratedValue
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Field(index=Index.NO, store=Store.YES)
    public String getBusLineName() {
        return this.busLineName;
    }

    public void setBusLineName(String busLine) {
        this.busLineName = busLine;
    }

    @ManyToMany(cascade={CascadeType.ALL})
    @IndexedEmbedded
    public Set<BusStop> getStops() {
        return this.stops;
    }

    public void setStops(Set<BusStop> stops) {
        this.stops = stops;
    }

    public Integer getBusLineCode() {
        return this.busLineCode;
    }

    public void setBusLineCode(Integer busLineCode) {
        this.busLineCode = busLineCode;
    }

    @Field
    public boolean isOperating() {
        return this.operating;
    }

    public void setOperating(boolean operating) {
        this.operating = operating;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.busLineName == null ? 0 : this.busLineName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BusLine other = (BusLine)obj;
        return !(this.busLineName == null ? other.busLineName != null : !this.busLineName.equals(other.busLineName));
    }
}

