/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.filter;

import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.OpenBitSet;

public class BestDriversFilter
extends Filter {
    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        AtomicReader reader = context.reader();
        OpenBitSet bitSet = new OpenBitSet((long)reader.maxDoc());
        DocsEnum termDocsEnum = reader.termDocsEnum(new Term("score", "5"));
        if (termDocsEnum == null) {
            return bitSet;
        }
        while (termDocsEnum.nextDoc() != Integer.MAX_VALUE) {
            int docID = termDocsEnum.docID();
            if (acceptDocs != null && !acceptDocs.get(docID)) continue;
            bitSet.set((long)docID);
        }
        return bitSet;
    }
}

