/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jmx;

import java.io.File;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.testsupport.TestConstants;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NoMBeansEnabledTest
extends SearchTestBase {
    MBeanServer mbeanServer;

    @Test
    public void testMBeanNotRegisteredWithoutExplicitProperty() throws Exception {
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName name = new ObjectName("org.hibernate.search.jmx:type=StatisticsInfoMBean");
        Assert.assertFalse((String)"Without 'hibernate.search.jmx_enabled' set the configuration info MBean should not be registered", (boolean)this.mbeanServer.isRegistered(name));
        name = new ObjectName("org.hibernate.search.jmx:type=IndexControlMBean");
        Assert.assertFalse((String)"Without 'hibernate.search.jmx_enabled' set the index control MBean should not be registered", (boolean)this.mbeanServer.isRegistered(name));
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        File targetDir = TestConstants.getTargetDir(NoMBeansEnabledTest.class);
        File simpleJndiDir = new File(targetDir, "simpleJndi");
        simpleJndiDir.mkdir();
        cfg.setProperty("hibernate.session_factory_name", "java:comp/SessionFactory");
        cfg.setProperty("hibernate.jndi.class", "org.osjava.sj.SimpleContextFactory");
        cfg.setProperty("hibernate.jndi.org.osjava.sj.root", simpleJndiDir.getAbsolutePath());
        cfg.setProperty("hibernate.jndi.org.osjava.sj.jndi.shared", "true");
    }

    @Override
    @Before
    public void setUp() throws Exception {
        ObjectName indexBeanObjectName;
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName statisticsBeanObjectName = new ObjectName("org.hibernate.search.jmx:type=StatisticsInfoMBean");
        if (this.mbeanServer.isRegistered(statisticsBeanObjectName)) {
            this.mbeanServer.unregisterMBean(statisticsBeanObjectName);
        }
        if (this.mbeanServer.isRegistered(indexBeanObjectName = new ObjectName("org.hibernate.search.jmx:type=IndexControlMBean"))) {
            this.mbeanServer.unregisterMBean(indexBeanObjectName);
        }
        this.forceConfigurationRebuild();
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[0];
    }
}

